/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.model.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.eclipse.chemclipse.model.core.IPeakIntensityValues;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.support.ITwoPoints;
import org.eclipse.chemclipse.model.support.TwoPoints;
import org.eclipse.chemclipse.numeric.core.IPoint;
import org.eclipse.chemclipse.numeric.core.Point;
import org.eclipse.chemclipse.numeric.equations.LinearEquation;
import org.eclipse.chemclipse.numeric.exceptions.PointIsNullException;

public abstract class AbstractPeakIntensityValues
implements IPeakIntensityValues {
    private static final long serialVersionUID = 1597422380319731942L;
    private NavigableMap<Integer, Float> intensityValues = new TreeMap<Integer, Float>();
    private float maxIntensity = 100.0f;

    public AbstractPeakIntensityValues() {
    }

    public AbstractPeakIntensityValues(float maxIntensity) {
        this();
        if (maxIntensity > 0.0f) {
            this.maxIntensity = maxIntensity;
        }
    }

    @Override
    public void addIntensityValue(int retentionTime, float relativeIntensity) {
        if (retentionTime >= 0 && relativeIntensity >= 0.0f && relativeIntensity <= this.maxIntensity) {
            this.intensityValues.put(retentionTime, Float.valueOf(relativeIntensity));
        }
    }

    @Override
    public Map.Entry<Integer, Float> getHighestIntensityValue() {
        for (Map.Entry<Integer, Float> entry : this.intensityValues.entrySet()) {
            if (((Float)entry.getValue()).floatValue() != this.maxIntensity) continue;
            return entry;
        }
        return null;
    }

    @Override
    public Map.Entry<Integer, Float> getIntensityValue(int retentionTime) {
        if (retentionTime >= this.getStartRetentionTime() && retentionTime <= this.getStopRetentionTime()) {
            return this.intensityValues.floorEntry(retentionTime);
        }
        return null;
    }

    @Override
    public int getStartRetentionTime() {
        int retentionTime = 0;
        if (this.size() > 0) {
            retentionTime = (Integer)this.intensityValues.firstKey();
        }
        return retentionTime;
    }

    @Override
    public int getStopRetentionTime() {
        int retentionTime = 0;
        if (this.size() > 0) {
            retentionTime = (Integer)this.intensityValues.lastKey();
        }
        return retentionTime;
    }

    @Override
    public void replaceRetentionTimes(List<Integer> retentionTimes) {
        if (this.intensityValues.size() == retentionTimes.size()) {
            int i = 0;
            TreeMap<Integer, Float> intensityValuesNew = new TreeMap<Integer, Float>();
            for (Map.Entry intensityValue : this.intensityValues.entrySet()) {
                intensityValuesNew.put(retentionTimes.get(i++), (Float)intensityValue.getValue());
            }
            this.intensityValues = intensityValuesNew;
        }
    }

    @Override
    public int size() {
        return this.intensityValues.size();
    }

    @Override
    public LinearEquation calculateIncreasingInflectionPointEquation(float totalSignal) throws PeakException {
        Map.Entry<Integer, Float> entry = this.getHighestIntensityValue();
        if (entry != null) {
            NavigableMap<Integer, Float> increasingValues = this.intensityValues.headMap(entry.getKey(), true);
            return this.calculateInflectionPointEquation(increasingValues, totalSignal);
        }
        return null;
    }

    @Override
    public LinearEquation calculateDecreasingInflectionPointEquation(float totalSignal) throws PeakException {
        Map.Entry<Integer, Float> entry = this.getHighestIntensityValue();
        if (entry != null) {
            NavigableMap<Integer, Float> decreasingValues = this.intensityValues.tailMap(entry.getKey(), true);
            return this.calculateInflectionPointEquation(decreasingValues, totalSignal);
        }
        return null;
    }

    @Override
    public List<Integer> getRetentionTimes() {
        return new ArrayList<Integer>(this.intensityValues.keySet());
    }

    @Override
    public void normalize() {
        float maxIntensityValue = ((Float)Collections.max(this.intensityValues.values())).floatValue();
        this.maxIntensity = 100.0f;
        for (int key : this.intensityValues.navigableKeySet()) {
            float actualIntensity = ((Float)this.intensityValues.get(key)).floatValue();
            this.intensityValues.put(key, Float.valueOf(this.calculateNormalizedIntensityValue(maxIntensityValue, actualIntensity)));
        }
    }

    private float calculateNormalizedIntensityValue(float maxIntensityValue, float actualIntensity) {
        float result = 0.0f;
        if (maxIntensityValue != 0.0f) {
            result = maxIntensityValue == actualIntensity ? 100.0f : this.maxIntensity / maxIntensityValue * actualIntensity;
        }
        return result;
    }

    private LinearEquation calculateInflectionPointEquation(NavigableMap<Integer, Float> values, float totalSignal) throws PeakException {
        TreeMap<Double, TwoPoints> slopes = new TreeMap<Double, TwoPoints>();
        Point p1 = null;
        Map.Entry<Integer, Float> e1 = null;
        Point p2 = null;
        Map.Entry<Integer, Float> e2 = null;
        TwoPoints points = null;
        ArrayList keys = new ArrayList(values.keySet());
        int i = 0;
        while (i < keys.size() - 1) {
            if (e1 == null) {
                e1 = values.floorEntry((Integer)keys.get(i));
                p1 = new Point((double)e1.getKey().intValue(), (double)(e1.getValue().floatValue() / this.maxIntensity * totalSignal));
            } else {
                e1 = e2;
                p1 = p2;
            }
            e2 = values.floorEntry((Integer)keys.get(i + 1));
            p2 = new Point((double)e2.getKey().intValue(), (double)(e2.getValue().floatValue() / this.maxIntensity * totalSignal));
            try {
                points = new TwoPoints((IPoint)p1, (IPoint)p2);
                slopes.put(Math.abs(points.getSlope()), points);
            }
            catch (PointIsNullException pointIsNullException) {}
            ++i;
        }
        Map.Entry entry = slopes.lastEntry();
        if (entry != null) {
            return ((ITwoPoints)entry.getValue()).getLinearEquation();
        }
        throw new PeakException("The inflection point equation could not be calculated.");
    }
}

