/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import java.io.Serializable;
import org.ejml.data.Matrix;
import org.ejml.data.RealMatrix64F;
import org.ejml.data.ReshapeMatrix;

public class DenseD2Matrix64F
implements Serializable,
ReshapeMatrix,
RealMatrix64F {
    public double[][] data;
    public int numRows;
    public int numCols;

    public DenseD2Matrix64F(int numRows, int numCols) {
        this.data = new double[numRows][numCols];
        this.numRows = numRows;
        this.numCols = numCols;
    }

    @Override
    public void reshape(int numRows, int numCols) {
        if (numRows > this.data.length) {
            throw new IllegalArgumentException("Requested number of rows is too great.");
        }
        this.numRows = numRows;
        if (numCols > this.data[0].length) {
            throw new IllegalArgumentException("Requested number of columns is too great.");
        }
        this.numCols = numCols;
    }

    @Override
    public double get(int row, int col) {
        return this.data[row][col];
    }

    @Override
    public void set(int row, int col, double val) {
        this.data[row][col] = val;
    }

    @Override
    public double unsafe_get(int row, int col) {
        return this.get(row, col);
    }

    @Override
    public void unsafe_set(int row, int col, double val) {
        this.set(row, col, val);
    }

    @Override
    public int getNumElements() {
        return this.numRows * this.numCols;
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public int getNumCols() {
        return this.numCols;
    }

    @Override
    public void print() {
    }

    @Override
    public <T extends Matrix> T copy() {
        return null;
    }

    @Override
    public void set(Matrix original) {
        throw new RuntimeException("Not yet supported");
    }
}

