/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.chol;

import org.ejml.alg.dense.decomposition.chol.CholeskyDecompositionCommon_D64;

public class CholeskyDecompositionInner_D64
extends CholeskyDecompositionCommon_D64 {
    public CholeskyDecompositionInner_D64() {
        super(true);
    }

    public CholeskyDecompositionInner_D64(boolean lower) {
        super(lower);
    }

    @Override
    protected boolean decomposeLower() {
        int j;
        double div_el_ii = 0.0;
        int i = 0;
        while (i < this.n) {
            j = i;
            while (j < this.n) {
                double sum = this.t[i * this.n + j];
                int iEl = i * this.n;
                int jEl = j * this.n;
                int end = iEl + i;
                while (iEl < end) {
                    sum -= this.t[iEl] * this.t[jEl];
                    ++iEl;
                    ++jEl;
                }
                if (i == j) {
                    double el_ii;
                    if (sum <= 0.0) {
                        return false;
                    }
                    this.t[i * this.n + i] = el_ii = Math.sqrt(sum);
                    div_el_ii = 1.0 / el_ii;
                } else {
                    this.t[j * this.n + i] = sum * div_el_ii;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.n) {
            j = i + 1;
            while (j < this.n) {
                this.t[i * this.n + j] = 0.0;
                ++j;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected boolean decomposeUpper() {
        int j;
        double div_el_ii = 0.0;
        int i = 0;
        while (i < this.n) {
            j = i;
            while (j < this.n) {
                double sum = this.t[i * this.n + j];
                int k = 0;
                while (k < i) {
                    sum -= this.t[k * this.n + i] * this.t[k * this.n + j];
                    ++k;
                }
                if (i == j) {
                    double el_ii;
                    if (sum <= 0.0) {
                        return false;
                    }
                    this.t[i * this.n + i] = el_ii = Math.sqrt(sum);
                    div_el_ii = 1.0 / el_ii;
                } else {
                    this.t[i * this.n + j] = sum * div_el_ii;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.n) {
            j = 0;
            while (j < i) {
                this.t[i * this.n + j] = 0.0;
                ++j;
            }
            ++i;
        }
        return true;
    }
}

