/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.core;

import org.eclipse.chemclipse.chromatogram.filter.processing.ChromatogramFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.filter.processing.IChromatogramFilterProcessingInfo;
import org.eclipse.chemclipse.chromatogram.filter.result.ChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.IChromatogramFilterResult;
import org.eclipse.chemclipse.chromatogram.filter.result.ResultStatus;
import org.eclipse.chemclipse.chromatogram.filter.settings.IChromatogramFilterSettings;
import org.eclipse.chemclipse.chromatogram.msd.filter.core.chromatogram.AbstractChromatogramFilterMSD;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.internal.calculator.SubtractCalculator;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.msd.filter.supplier.subtract.settings.ISupplierFilterSettings;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.processing.core.IProcessingMessage;
import org.eclipse.chemclipse.processing.core.MessageType;
import org.eclipse.chemclipse.processing.core.ProcessingMessage;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramFilter
extends AbstractChromatogramFilterMSD {
    private static final String DESCRIPTION = "Subtract Filter Chromatogram";

    public IChromatogramFilterProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IChromatogramFilterSettings chromatogramFilterSettings, IProgressMonitor monitor) {
        ChromatogramFilterProcessingInfo processingInfo = new ChromatogramFilterProcessingInfo();
        processingInfo.addMessages(this.validate(chromatogramSelection, chromatogramFilterSettings));
        if (processingInfo.hasErrorMessages()) {
            return processingInfo;
        }
        if (chromatogramFilterSettings instanceof ISupplierFilterSettings) {
            ISupplierFilterSettings subtractFilterSettings = (ISupplierFilterSettings)chromatogramFilterSettings;
            SubtractCalculator subtractCalculator = new SubtractCalculator();
            subtractCalculator.subtractPeakMassSpectraFromChromatogramSelection(chromatogramSelection, subtractFilterSettings);
            processingInfo.addMessage((IProcessingMessage)new ProcessingMessage(MessageType.INFO, DESCRIPTION, "The mass spectrum has been subtracted successfully from the chromatogram selection."));
        } else {
            processingInfo.addErrorMessage(DESCRIPTION, "The filter settings instance is not a type of:" + ISupplierFilterSettings.class);
        }
        ChromatogramFilterResult chromatogramFilterResult = new ChromatogramFilterResult(ResultStatus.OK, "The subtract filter has been applied successfully.");
        processingInfo.setChromatogramFilterResult((IChromatogramFilterResult)chromatogramFilterResult);
        return processingInfo;
    }

    public IChromatogramFilterProcessingInfo applyFilter(IChromatogramSelectionMSD chromatogramSelection, IProgressMonitor monitor) {
        ISupplierFilterSettings chromatogramFilterSettings = PreferenceSupplier.getChromatogramFilterSettings();
        return this.applyFilter(chromatogramSelection, chromatogramFilterSettings, monitor);
    }
}

