/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.provider;

import org.eclipse.chemclipse.model.quantitation.IRetentionIndexWindow;
import org.eclipse.chemclipse.model.quantitation.IRetentionTimeWindow;
import org.eclipse.chemclipse.msd.model.core.quantitation.IQuantitationCompoundMSD;
import org.eclipse.chemclipse.support.ui.swt.AbstractRecordTableComparator;
import org.eclipse.chemclipse.support.ui.swt.IRecordTableComparator;
import org.eclipse.jface.viewers.Viewer;

public class QuantitationCompoundTableComparator
extends AbstractRecordTableComparator
implements IRecordTableComparator {
    public int compare(Viewer viewer, Object e1, Object e2) {
        int sortOrder = 0;
        if (e1 instanceof IQuantitationCompoundMSD && e2 instanceof IQuantitationCompoundMSD) {
            IQuantitationCompoundMSD compound1 = (IQuantitationCompoundMSD)e1;
            IRetentionTimeWindow retentionTimeWindow1 = compound1.getRetentionTimeWindow();
            IRetentionIndexWindow retentionIndexWindow1 = compound1.getRetentionIndexWindow();
            IQuantitationCompoundMSD compound2 = (IQuantitationCompoundMSD)e2;
            IRetentionTimeWindow retentionTimeWindow2 = compound2.getRetentionTimeWindow();
            IRetentionIndexWindow retentionIndexWindow2 = compound2.getRetentionIndexWindow();
            switch (this.getPropertyIndex()) {
                case 0: {
                    sortOrder = compound2.getName().compareTo(compound1.getName());
                    break;
                }
                case 1: {
                    sortOrder = compound2.getChemicalClass().compareTo(compound1.getChemicalClass());
                    break;
                }
                case 2: {
                    sortOrder = compound2.getConcentrationUnit().compareTo(compound1.getConcentrationUnit());
                    break;
                }
                case 3: {
                    sortOrder = compound2.getCalibrationMethod().toString().compareTo(compound1.getCalibrationMethod().toString());
                    break;
                }
                case 4: {
                    sortOrder = Boolean.valueOf(compound2.isCrossZero()).compareTo(compound1.isCrossZero());
                    break;
                }
                case 5: {
                    sortOrder = Boolean.valueOf(compound2.isUseTIC()).compareTo(compound1.isUseTIC());
                    break;
                }
                case 6: {
                    sortOrder = retentionTimeWindow2.getRetentionTime() - retentionTimeWindow1.getRetentionTime();
                    break;
                }
                case 7: {
                    sortOrder = Float.compare(retentionTimeWindow2.getAllowedNegativeDeviation(), retentionTimeWindow1.getAllowedNegativeDeviation());
                    break;
                }
                case 8: {
                    sortOrder = Float.compare(retentionTimeWindow2.getAllowedPositiveDeviation(), retentionTimeWindow1.getAllowedPositiveDeviation());
                    break;
                }
                case 9: {
                    sortOrder = Float.compare(retentionIndexWindow2.getRetentionIndex(), retentionIndexWindow1.getRetentionIndex());
                    break;
                }
                case 10: {
                    sortOrder = Float.compare(retentionIndexWindow2.getAllowedNegativeDeviation(), retentionIndexWindow1.getAllowedNegativeDeviation());
                    break;
                }
                case 11: {
                    sortOrder = Float.compare(retentionIndexWindow2.getAllowedPositiveDeviation(), retentionIndexWindow1.getAllowedPositiveDeviation());
                    break;
                }
                default: {
                    sortOrder = 0;
                }
            }
        }
        if (this.getDirection() == 0) {
            sortOrder = -sortOrder;
        }
        return sortOrder;
    }
}

