/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.catalog;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.ServiceLocator;
import org.eclipse.epp.internal.mpc.core.service.Identifiable;
import org.eclipse.epp.internal.mpc.core.service.Node;
import org.eclipse.epp.internal.mpc.core.service.SearchResult;
import org.eclipse.epp.internal.mpc.core.util.URLUtil;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalogSource;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCategory;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceInfo;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeInstallableUnitItem;
import org.eclipse.epp.internal.mpc.ui.catalog.Messages;
import org.eclipse.epp.internal.mpc.ui.catalog.ResourceProvider;
import org.eclipse.epp.mpc.core.model.ICategories;
import org.eclipse.epp.mpc.core.model.ICategory;
import org.eclipse.epp.mpc.core.model.IIdentifiable;
import org.eclipse.epp.mpc.core.model.IIu;
import org.eclipse.epp.mpc.core.model.IIus;
import org.eclipse.epp.mpc.core.model.IMarket;
import org.eclipse.epp.mpc.core.model.INews;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.core.model.ISearchResult;
import org.eclipse.epp.mpc.core.service.IMarketplaceService;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.epp.mpc.ui.MarketplaceUrlHandler;
import org.eclipse.equinox.internal.p2.discovery.AbstractCatalogSource;
import org.eclipse.equinox.internal.p2.discovery.AbstractDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Icon;
import org.eclipse.equinox.internal.p2.discovery.model.Overview;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private static final Pattern BREAK_PATTERN = Pattern.compile("<!--\\s*break\\s*-->");
    protected final CatalogDescriptor catalogDescriptor;
    private final IMarketplaceService marketplaceService;
    private MarketplaceCatalogSource source;
    private MarketplaceInfo marketplaceInfo;
    private Map<String, IInstallableUnit> featureIUById;

    public MarketplaceDiscoveryStrategy(CatalogDescriptor catalogDescriptor) {
        if (catalogDescriptor == null) {
            throw new IllegalArgumentException();
        }
        this.catalogDescriptor = catalogDescriptor;
        this.marketplaceService = this.createMarketplaceService();
        this.source = new MarketplaceCatalogSource(this.marketplaceService);
        this.marketplaceInfo = MarketplaceInfo.getInstance();
    }

    @Deprecated
    public IMarketplaceService createMarketplaceService() {
        return this.acquireMarketplaceService();
    }

    protected IMarketplaceService acquireMarketplaceService() {
        String baseUrl = this.catalogDescriptor.getUrl().toExternalForm();
        return ServiceLocator.getCompatibilityLocator().getMarketplaceService(baseUrl);
    }

    @Deprecated
    public static Map<String, String> computeDefaultRequestMetaParameters() {
        return ServiceLocator.computeDefaultRequestMetaParameters();
    }

    public void dispose() {
        if (this.source != null) {
            this.source.dispose();
            this.source = null;
        }
        if (this.marketplaceInfo != null) {
            final MarketplaceInfo fMarketplaceInfo = this.marketplaceInfo;
            new Job(Messages.MarketplaceDiscoveryStrategy_saveMarketplaceInfoJobName){
                {
                    super($anonymous0);
                    this.setSystem(true);
                    this.setPriority(20);
                    this.setUser(false);
                }

                public boolean belongsTo(Object family) {
                    BundleContext bundleContext = MarketplaceClientUiPlugin.getBundleContext();
                    MarketplaceClientUiPlugin plugin = MarketplaceClientUiPlugin.getInstance();
                    return bundleContext != null && (family == bundleContext || family == bundleContext.getBundle()) || plugin != null && family == plugin;
                }

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        fMarketplaceInfo.save();
                    }
                    catch (Exception e) {
                        return MarketplaceClientCore.computeStatus((Exception)e, (String)Messages.MarketplaceDiscoveryStrategy_failedToSaveMarketplaceInfo);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
            this.marketplaceInfo = null;
        }
        super.dispose();
    }

    public void performDiscovery(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(Messages.MarketplaceDiscoveryStrategy_loadingMarketplace, 10000000);
        try {
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)new SubProgressMonitor(monitor, 3333333));
            catalogCategory.setContents(MarketplaceCategory.Contents.FEATURED);
            ISearchResult featured = this.marketplaceService.featured((IProgressMonitor)new SubProgressMonitor(monitor, 3333333));
            this.handleSearchResult(catalogCategory, featured, (IProgressMonitor)new SubProgressMonitor(monitor, 3333333));
            this.maybeAddCatalogItem(catalogCategory);
        }
        finally {
            monitor.done();
        }
    }

    protected void handleSearchResult(MarketplaceCategory catalogCategory, ISearchResult result, IProgressMonitor monitor) {
        if (!result.getNodes().isEmpty()) {
            int totalWork = 10000000;
            monitor.beginTask(Messages.MarketplaceDiscoveryStrategy_loadingResources, totalWork);
            try {
                for (INode node : result.getNodes()) {
                    try {
                        MarketplaceNodeCatalogItem catalogItem = new MarketplaceNodeCatalogItem();
                        catalogItem.setMarketplaceUrl(this.catalogDescriptor.getUrl());
                        catalogItem.setId(node.getId());
                        catalogItem.setName(this.getCatalogItemName(node));
                        catalogItem.setCategoryId(catalogCategory.getId());
                        ICategories categories = node.getCategories();
                        if (categories != null) {
                            for (ICategory category : categories.getCategory()) {
                                catalogItem.addTag(new Tag(ICategory.class, category.getId(), category.getName()));
                            }
                        }
                        catalogItem.setData(node);
                        catalogItem.setSource(this.source);
                        catalogItem.setLicense(node.getLicense());
                        IIus ius = node.getIus();
                        if (ius != null) {
                            ArrayList<MarketplaceNodeInstallableUnitItem> installableUnitItems = new ArrayList<MarketplaceNodeInstallableUnitItem>();
                            for (IIu iu : ius.getIuElements()) {
                                MarketplaceNodeInstallableUnitItem iuItem = new MarketplaceNodeInstallableUnitItem();
                                iuItem.init(iu);
                                installableUnitItems.add(iuItem);
                            }
                            catalogItem.setInstallableUnitItems(installableUnitItems);
                        }
                        if (node.getShortdescription() == null && node.getBody() != null) {
                            String shortDescriptionText;
                            int start;
                            String descriptionText = node.getBody();
                            Matcher matcher = BREAK_PATTERN.matcher(node.getBody());
                            if (matcher.find() && (start = matcher.start()) > 0 && (shortDescriptionText = descriptionText.substring(0, start).trim()).length() > 0) {
                                descriptionText = shortDescriptionText;
                            }
                            catalogItem.setDescription(descriptionText);
                        } else {
                            catalogItem.setDescription(node.getShortdescription());
                        }
                        catalogItem.setProvider(node.getCompanyname());
                        String updateurl = node.getUpdateurl();
                        if (updateurl != null) {
                            try {
                                updateurl = updateurl.trim();
                                URLUtil.toURL((String)updateurl);
                                catalogItem.setSiteUrl(updateurl);
                            }
                            catch (MalformedURLException malformedURLException) {}
                        }
                        if (catalogItem.getInstallableUnits() == null || catalogItem.getInstallableUnits().isEmpty() || catalogItem.getSiteUrl() == null) {
                            catalogItem.setAvailable(false);
                        }
                        if (node.getImage() != null) {
                            if (!this.source.getResourceProvider().containsResource(node.getImage())) {
                                MarketplaceDiscoveryStrategy.cacheResource(this.source.getResourceProvider(), catalogItem, node.getImage());
                            }
                            this.createIcon(catalogItem, node);
                        }
                        if (node.getBody() != null || node.getScreenshot() != null) {
                            Overview overview = new Overview();
                            overview.setItem((CatalogItem)catalogItem);
                            overview.setSummary(node.getBody());
                            overview.setUrl(node.getUrl());
                            catalogItem.setOverview(overview);
                            if (node.getScreenshot() != null) {
                                if (!this.source.getResourceProvider().containsResource(node.getScreenshot())) {
                                    MarketplaceDiscoveryStrategy.cacheResource(this.source.getResourceProvider(), catalogItem, node.getScreenshot());
                                }
                                overview.setScreenshot(node.getScreenshot());
                            }
                        }
                        this.items.add(catalogItem);
                        this.marketplaceInfo.map(catalogItem.getMarketplaceUrl(), node);
                        this.marketplaceInfo.computeInstalled(this.computeInstalledFeatures(monitor), catalogItem);
                    }
                    catch (RuntimeException ex) {
                        MarketplaceClientUi.error(NLS.bind((String)Messages.MarketplaceDiscoveryStrategy_ParseError, (Object)(node == null ? "null" : node.getId())), ex);
                    }
                }
            }
            finally {
                monitor.done();
            }
            if (result.getMatchCount() != null) {
                catalogCategory.setMatchCount(result.getMatchCount());
                if (result.getMatchCount() > result.getNodes().size()) {
                    this.addCatalogItem(catalogCategory);
                }
            }
        }
    }

    public static void cacheResource(ResourceProvider resourceProvider, CatalogItem catalogItem, String resource) {
        if (!resourceProvider.containsResource(resource)) {
            String requestSource = NLS.bind((String)Messages.MarketplaceDiscoveryStrategy_requestSource, (Object)catalogItem.getName(), (Object)catalogItem.getId());
            try {
                resourceProvider.retrieveResource(requestSource, resource);
            }
            catch (URISyntaxException e) {
                MarketplaceClientUi.log(2, Messages.MarketplaceDiscoveryStrategy_badUri, catalogItem.getName(), catalogItem.getId(), resource, e);
            }
            catch (IOException e) {
                MarketplaceClientUi.log(2, Messages.MarketplaceDiscoveryStrategy_downloadError, catalogItem.getName(), catalogItem.getId(), resource, e);
            }
        }
    }

    private String getCatalogItemName(INode node) {
        String name = node.getName();
        String version = node.getVersion();
        return version == null || version.length() == 0 ? name : NLS.bind((String)Messages.MarketplaceDiscoveryStrategy_Name_and_Version, (Object)name, (Object)version);
    }

    public void maybeAddCatalogItem(MarketplaceCategory catalogCategory) {
        CatalogItem catalogItem;
        if (!this.items.isEmpty() && (catalogItem = (CatalogItem)this.items.get(this.items.size() - 1)).getData() != this.catalogDescriptor) {
            this.addCatalogItem(catalogCategory);
        }
    }

    public void addCatalogItem(MarketplaceCategory catalogCategory) {
        CatalogItem catalogItem = new CatalogItem();
        catalogItem.setSource((AbstractCatalogSource)this.source);
        catalogItem.setData((Object)this.catalogDescriptor);
        catalogItem.setId(this.catalogDescriptor.getUrl().toString());
        catalogItem.setCategoryId(catalogCategory.getId());
        this.items.add(catalogItem);
    }

    private void createIcon(CatalogItem catalogItem, INode node) {
        Icon icon = new Icon();
        icon.setImage32(node.getImage());
        icon.setImage48(node.getImage());
        icon.setImage64(node.getImage());
        catalogItem.setIcon(icon);
    }

    public void performQuery(IMarket market, ICategory category, String queryText, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MarketplaceDiscoveryStrategy_searchingMarketplace, (int)1000000);
        try {
            ISearchResult result;
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)progress.newChild(1));
            catalogCategory.setContents(MarketplaceCategory.Contents.QUERY);
            try {
                result = this.performNodeQuery(queryText, (IProgressMonitor)progress.newChild(500000));
            }
            catch (CoreException coreException) {
                result = null;
            }
            if (result == null) {
                ICategory resolvedCategory;
                IMarket resolvedMarket;
                try {
                    resolvedMarket = this.resolve((IIdentifiable)market, (List)catalogCategory.getMarkets());
                    resolvedCategory = this.resolveCategory(category, catalogCategory.getMarkets());
                }
                catch (IllegalArgumentException ex) {
                    throw new CoreException(MarketplaceClientCore.computeStatus((Exception)ex, (String)Messages.MarketplaceDiscoveryStrategy_invalidFilter));
                }
                catch (NoSuchElementException ex) {
                    throw new CoreException(MarketplaceClientCore.computeStatus((Exception)ex, (String)Messages.MarketplaceDiscoveryStrategy_unknownFilter));
                }
                progress.setWorkRemaining(1000000);
                result = this.marketplaceService.search(resolvedMarket, resolvedCategory, queryText, (IProgressMonitor)progress.newChild(500000));
            }
            this.handleSearchResult(catalogCategory, result, (IProgressMonitor)progress.newChild(500000));
            if (result.getNodes().isEmpty()) {
                catalogCategory.setMatchCount(0);
                this.addCatalogItem(catalogCategory);
            }
        }
        finally {
            progress.done();
        }
    }

    private ICategory resolveCategory(ICategory category, List<? extends IMarket> markets) throws IllegalArgumentException, NoSuchElementException {
        if (category != null && category.getId() == null) {
            if (category.getUrl() == null && category.getName() == null) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.MarketplaceDiscoveryStrategy_unidentifiableItem, (Object)category));
            }
            for (IMarket iMarket : markets) {
                List categories = iMarket.getCategory();
                ICategory resolved = this.resolve(category, categories);
                if (resolved == null) continue;
                return resolved;
            }
            if (category.getUrl() != null) {
                throw new NoSuchElementException(NLS.bind((String)Messages.MarketplaceDiscoveryStrategy_noUrlMatch, (Object)category.getUrl()));
            }
            throw new NoSuchElementException(NLS.bind((String)Messages.MarketplaceDiscoveryStrategy_noNameMatch, (Object)category.getName()));
        }
        return category;
    }

    private <T extends IIdentifiable> T resolve(T id, List<? extends T> candidates) throws IllegalArgumentException, NoSuchElementException {
        if (id != null && id.getId() == null) {
            if (id.getUrl() == null && id.getName() == null) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.MarketplaceDiscoveryStrategy_unidentifiableItem, id));
            }
            for (IIdentifiable candidate : candidates) {
                if (!Identifiable.matches((IIdentifiable)candidate, id)) continue;
                return (T)candidate;
            }
            if (id.getUrl() != null) {
                throw new NoSuchElementException(NLS.bind((String)Messages.MarketplaceDiscoveryStrategy_noUrlMatch, (Object)id.getUrl()));
            }
            throw new NoSuchElementException(NLS.bind((String)Messages.MarketplaceDiscoveryStrategy_noNameMatch, (Object)id.getName()));
        }
        return id;
    }

    private ISearchResult performNodeQuery(String nodeUrl, IProgressMonitor progress) throws CoreException {
        final INode[] queryNode = new INode[1];
        MarketplaceUrlHandler urlHandler = new MarketplaceUrlHandler(){

            protected boolean handleNode(CatalogDescriptor descriptor, String url, INode node) {
                queryNode[0] = node;
                return true;
            }
        };
        if (urlHandler.handleUri(nodeUrl) && queryNode[0] != null) {
            INode node = this.marketplaceService.getNode(queryNode[0], progress);
            SearchResult result = new SearchResult();
            result.setMatchCount(Integer.valueOf(1));
            result.setNodes(Collections.singletonList((Node)node));
            return result;
        }
        return null;
    }

    public void recent(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.MarketplaceDiscoveryStrategy_searchingMarketplace, 1000000);
        try {
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            catalogCategory.setContents(MarketplaceCategory.Contents.RECENT);
            ISearchResult result = this.marketplaceService.recent((IProgressMonitor)new SubProgressMonitor(monitor, 500000));
            this.handleSearchResult(catalogCategory, result, (IProgressMonitor)new SubProgressMonitor(monitor, 500000));
            this.maybeAddCatalogItem(catalogCategory);
        }
        finally {
            monitor.done();
        }
    }

    public void related(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.MarketplaceDiscoveryStrategy_searchingMarketplace, 1000000);
        try {
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            catalogCategory.setContents(MarketplaceCategory.Contents.RELATED);
            SearchResult installed = this.computeInstalled((IProgressMonitor)new SubProgressMonitor(monitor, 250000));
            if (!monitor.isCanceled()) {
                ISearchResult result = this.marketplaceService.related(installed.getNodes(), (IProgressMonitor)new SubProgressMonitor(monitor, 375000));
                this.handleSearchResult(catalogCategory, result, (IProgressMonitor)new SubProgressMonitor(monitor, 375000));
                this.maybeAddCatalogItem(catalogCategory);
            }
        }
        finally {
            monitor.done();
        }
    }

    public void featured(IProgressMonitor monitor, IMarket market, ICategory category) throws CoreException {
        monitor.beginTask(Messages.MarketplaceDiscoveryStrategy_searchingMarketplace, 1000000);
        try {
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            catalogCategory.setContents(MarketplaceCategory.Contents.FEATURED);
            ISearchResult result = this.marketplaceService.featured(market, category, (IProgressMonitor)new SubProgressMonitor(monitor, 500000));
            this.handleSearchResult(catalogCategory, result, (IProgressMonitor)new SubProgressMonitor(monitor, 500000));
            this.maybeAddCatalogItem(catalogCategory);
        }
        finally {
            monitor.done();
        }
    }

    public void popular(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.MarketplaceDiscoveryStrategy_searchingMarketplace, 1000000);
        try {
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            catalogCategory.setContents(MarketplaceCategory.Contents.POPULAR);
            ISearchResult result = this.marketplaceService.popular((IProgressMonitor)new SubProgressMonitor(monitor, 500000));
            this.handleSearchResult(catalogCategory, result, (IProgressMonitor)new SubProgressMonitor(monitor, 500000));
            this.maybeAddCatalogItem(catalogCategory);
        }
        finally {
            monitor.done();
        }
    }

    public void installed(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.MarketplaceDiscoveryStrategy_findingInstalled, 1000000);
        try {
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            catalogCategory.setContents(MarketplaceCategory.Contents.INSTALLED);
            SearchResult result = this.computeInstalled(monitor);
            if (!monitor.isCanceled()) {
                this.handleSearchResult(catalogCategory, (ISearchResult)result, (IProgressMonitor)new SubProgressMonitor(monitor, 500000));
            }
        }
        finally {
            monitor.done();
        }
    }

    protected SearchResult computeInstalled(IProgressMonitor monitor) throws CoreException {
        SearchResult result = new SearchResult();
        result.setNodes(new ArrayList());
        Map<String, IInstallableUnit> installedIUs = this.computeInstalledIUs(monitor);
        if (!monitor.isCanceled()) {
            Set<INode> catalogNodes = this.marketplaceInfo.computeInstalledNodes(this.catalogDescriptor.getUrl(), installedIUs);
            if (!catalogNodes.isEmpty()) {
                int unitWork = 1000000 / (2 * catalogNodes.size());
                for (INode node : catalogNodes) {
                    node = this.marketplaceService.getNode(node, monitor);
                    if (this.marketplaceInfo.computeInstalled(installedIUs.keySet(), node)) {
                        result.getNodes().add((Node)node);
                    }
                    monitor.worked(unitWork);
                }
            } else {
                monitor.worked(500000);
            }
        }
        return result;
    }

    public void performQuery(IProgressMonitor monitor, Set<String> nodeIds) throws CoreException {
        HashSet<Node> nodes = new HashSet<Node>();
        for (String nodeId : nodeIds) {
            Node node = new Node();
            node.setId(nodeId);
            nodes.add(node);
        }
        this.performNodeQuery(monitor, nodes);
    }

    public void performNodeQuery(IProgressMonitor monitor, Set<? extends INode> nodes) throws CoreException {
        monitor.beginTask(Messages.MarketplaceDiscoveryStrategy_searchingMarketplace, 1000000);
        try {
            MarketplaceCategory catalogCategory = this.findMarketplaceCategory((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            catalogCategory.setContents(MarketplaceCategory.Contents.QUERY);
            SearchResult result = new SearchResult();
            result.setNodes(new ArrayList());
            if (!monitor.isCanceled()) {
                if (!nodes.isEmpty()) {
                    int unitWork = 1000000 / (2 * nodes.size());
                    for (INode iNode : nodes) {
                        INode iNode2 = this.marketplaceService.getNode(iNode, monitor);
                        result.getNodes().add((Node)iNode2);
                        monitor.worked(unitWork);
                    }
                } else {
                    monitor.worked(500000);
                }
                result.setMatchCount(Integer.valueOf(result.getNodes().size()));
                this.handleSearchResult(catalogCategory, (ISearchResult)result, (IProgressMonitor)new SubProgressMonitor(monitor, 500000));
                this.maybeAddCatalogItem(catalogCategory);
            }
        }
        finally {
            monitor.done();
        }
    }

    @Deprecated
    protected Set<String> computeInstalledFeatures(IProgressMonitor monitor) {
        return this.computeInstalledIUs(monitor).keySet();
    }

    protected synchronized Map<String, IInstallableUnit> computeInstalledIUs(IProgressMonitor monitor) {
        if (this.featureIUById == null) {
            this.featureIUById = MarketplaceClientUi.computeInstalledIUsById(monitor);
        }
        return this.featureIUById;
    }

    protected MarketplaceCategory findMarketplaceCategory(IProgressMonitor monitor) throws CoreException {
        MarketplaceCategory catalogCategory = null;
        monitor.beginTask(Messages.MarketplaceDiscoveryStrategy_catalogCategory, 10000);
        try {
            for (CatalogCategory candidate : this.getCategories()) {
                if (candidate.getSource() != this.source) continue;
                catalogCategory = (MarketplaceCategory)candidate;
            }
            if (catalogCategory == null) {
                List markets = this.marketplaceService.listMarkets((IProgressMonitor)new SubProgressMonitor(monitor, 10000));
                catalogCategory = new MarketplaceCategory();
                catalogCategory.setId("<root>");
                catalogCategory.setName("<root>");
                catalogCategory.setSource(this.source);
                catalogCategory.setMarkets(markets);
                this.categories.add(catalogCategory);
            }
        }
        finally {
            monitor.done();
        }
        return catalogCategory;
    }

    public INews performNewsDiscovery(IProgressMonitor monitor) throws CoreException {
        return this.marketplaceService.news(monitor);
    }

    public void installErrorReport(IProgressMonitor monitor, IStatus result, Set<CatalogItem> items, IInstallableUnit[] operationIUs, String resolutionDetails) throws CoreException {
        monitor.beginTask(Messages.MarketplaceDiscoveryStrategy_sendingErrorNotification, 100);
        try {
            HashSet<Node> nodes = new HashSet<Node>();
            for (CatalogItem item : items) {
                Object data = item.getData();
                if (!(data instanceof INode)) continue;
                nodes.add((Node)data);
            }
            HashSet<String> iuIdsAndVersions = new HashSet<String>();
            IInstallableUnit[] iInstallableUnitArray = operationIUs;
            int n = operationIUs.length;
            int n2 = 0;
            while (n2 < n) {
                IInstallableUnit iu = iInstallableUnitArray[n2];
                String id = iu.getId();
                String version = iu.getVersion() == null ? null : iu.getVersion().toString();
                iuIdsAndVersions.add(String.valueOf(id) + "," + version);
                ++n2;
            }
            this.marketplaceService.reportInstallError(result, nodes, iuIdsAndVersions, resolutionDetails, monitor);
        }
        finally {
            monitor.done();
        }
    }
}

