/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.editors;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.io.BatchProcessJobWriter;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.model.IBatchProcessJob;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.editors.BatchProcessEditorPage;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.editors.IMultiEditorPage;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.editors.InputEntriesPage;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.editors.OutputEntriesPage;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.editors.ProcessEntriesPage;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.editors.ReportEntriesPage;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.internal.runnables.BatchProcessExportRunnable;
import org.eclipse.chemclipse.chromatogram.msd.process.supplier.batchprocess.ui.internal.runnables.BatchProcessImportRunnable;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotWriteableException;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;

public class BatchProcessJobEditor
extends MultiPageEditorPart {
    private static final Logger logger = Logger.getLogger(BatchProcessJobEditor.class);
    private IFile editorBatchProcessJobFile;
    private IBatchProcessJob batchProcessJob;
    private boolean isDirty = false;
    private BatchProcessEditorPage batchProcessEditorPage;
    private List<IMultiEditorPage> pages = new ArrayList<IMultiEditorPage>();
    private static final String BATCHPROCESS_EDITOR_PAGE = "bpp";
    public static final String INPUT_FILES_PAGE = "ifp";
    public static final String PROCESS_ENTRIES_PAGE = "pep";
    public static final String OUTPUT_FILES_PAGE = "ofp";
    public static final String REPORT_ENTRIES_PAGE = "rep";
    private HashMap<String, Integer> pagesMap = new HashMap();

    protected void setActivePage(String key) {
        Integer pageIndex;
        if (this.pagesMap != null && (pageIndex = this.pagesMap.get(key)) != null) {
            this.setActivePage(pageIndex);
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected void setDirty() {
        this.isDirty = true;
        this.firePropertyChange(257);
    }

    protected void createPages() {
        this.createBatchProcessEditorPage();
        this.createInputFilesPage();
        this.createProcessEntriesPage();
        this.createOutputFilesPage();
        this.createReportEntriesPage();
        this.setBatchProcessJobInPages();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        String fileName = input.getName();
        fileName = fileName.substring(0, fileName.length() - 4);
        this.setPartName(fileName);
        if (input instanceof IFileEditorInput) {
            this.editorBatchProcessJobFile = ((IFileEditorInput)input).getFile();
            Display display = Display.getCurrent();
            BatchProcessImportRunnable runnable = new BatchProcessImportRunnable(this.editorBatchProcessJobFile.getLocation().toFile());
            ProgressMonitorDialog monitor = new ProgressMonitorDialog(display.getActiveShell());
            try {
                monitor.run(false, true, (IRunnableWithProgress)runnable);
                this.batchProcessJob = runnable.getBatchProcessJob();
            }
            catch (InvocationTargetException e) {
                logger.warn((Object)e);
            }
            catch (InterruptedException e) {
                logger.warn((Object)e);
            }
        } else {
            throw new PartInitException("The file could't be loaded.");
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.editorBatchProcessJobFile != null) {
            BatchProcessJobWriter writer = new BatchProcessJobWriter();
            try {
                writer.writeBatchProcessJob(this.editorBatchProcessJobFile.getLocation().toFile(), this.batchProcessJob, monitor);
                this.isDirty = false;
                this.firePropertyChange(257);
            }
            catch (FileNotFoundException e) {
                logger.warn((Object)e);
            }
            catch (FileIsNotWriteableException e) {
                logger.warn((Object)e);
            }
            catch (IOException e) {
                logger.warn((Object)e);
            }
            catch (XMLStreamException e) {
                logger.warn((Object)e);
            }
        }
    }

    public void doSaveAs() {
        Display display = Display.getCurrent();
        Shell shell = display.getActiveShell();
        FileDialog dialog = new FileDialog(shell, 8192);
        dialog.setText("Save the batch job");
        dialog.setFileName("BatchJob.obj");
        String fileName = dialog.open();
        if (fileName != null) {
            File file = new File(fileName);
            BatchProcessExportRunnable runnable = new BatchProcessExportRunnable(file, this.batchProcessJob);
            ProgressMonitorDialog monitor = new ProgressMonitorDialog(display.getActiveShell());
            try {
                monitor.run(true, true, (IRunnableWithProgress)runnable);
            }
            catch (InvocationTargetException e) {
                logger.warn((Object)e);
            }
            catch (InterruptedException e) {
                logger.warn((Object)e);
            }
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    private void setBatchProcessJobInPages() {
        for (IMultiEditorPage page : this.pages) {
            if (page == null) continue;
            page.setBatchProcessJob(this.batchProcessJob);
        }
    }

    private void createBatchProcessEditorPage() {
        this.batchProcessEditorPage = new BatchProcessEditorPage(this, this.getContainer());
        this.pages.add(this.batchProcessEditorPage);
        this.pagesMap.put(BATCHPROCESS_EDITOR_PAGE, this.batchProcessEditorPage.getPageIndex());
        this.setPageText(this.pagesMap.get(BATCHPROCESS_EDITOR_PAGE), "Batch Process Job Editor");
    }

    private void createInputFilesPage() {
        InputEntriesPage page = new InputEntriesPage(this, this.getContainer());
        this.pages.add(page);
        this.pagesMap.put(INPUT_FILES_PAGE, page.getPageIndex());
        this.setPageText(this.pagesMap.get(INPUT_FILES_PAGE), "Input Files");
    }

    private void createProcessEntriesPage() {
        ProcessEntriesPage page = new ProcessEntriesPage(this, this.getContainer());
        this.pages.add(page);
        this.pagesMap.put(PROCESS_ENTRIES_PAGE, page.getPageIndex());
        this.setPageText(this.pagesMap.get(PROCESS_ENTRIES_PAGE), "Process Entries");
    }

    private void createOutputFilesPage() {
        OutputEntriesPage page = new OutputEntriesPage(this, this.getContainer());
        this.pages.add(page);
        this.pagesMap.put(OUTPUT_FILES_PAGE, page.getPageIndex());
        this.setPageText(this.pagesMap.get(OUTPUT_FILES_PAGE), "Output Files");
    }

    private void createReportEntriesPage() {
        ReportEntriesPage page = new ReportEntriesPage(this, this.getContainer());
        this.pages.add(page);
        this.pagesMap.put(REPORT_ENTRIES_PAGE, page.getPageIndex());
        this.setPageText(this.pagesMap.get(REPORT_ENTRIES_PAGE), "Report Supplier");
    }

    public void dispose() {
        for (IMultiEditorPage page : this.pages) {
            if (page == null) continue;
            page.dispose();
        }
        super.dispose();
    }
}

