/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.internal.axis;

import java.util.ArrayList;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.internal.ChartLayoutData;
import org.swtchart.internal.axis.Axis;

public class AxisTickMarks
implements PaintListener {
    private Chart chart;
    private Axis axis;
    private Color foreground;
    private int widthHint;
    private int heightHint;
    private Rectangle bounds;
    protected static final int LINE_WIDTH = 1;
    public static final int TICK_LENGTH = 5;
    private static final int DEFAULT_FOREGROUND = 9;

    public AxisTickMarks(Chart chart, Axis axis) {
        this.chart = chart;
        this.axis = axis;
        this.foreground = Display.getDefault().getSystemColor(9);
        chart.addPaintListener(this);
    }

    public void setForeground(Color color) {
        this.foreground = color == null ? Display.getDefault().getSystemColor(9) : color;
    }

    protected Color getForeground() {
        if (this.foreground.isDisposed()) {
            this.foreground = Display.getDefault().getSystemColor(9);
        }
        return this.foreground;
    }

    public Axis getAxis() {
        return this.axis;
    }

    protected void updateLayoutData() {
        this.widthHint = -1;
        this.heightHint = -1;
        if (!this.axis.getTick().isVisible()) {
            this.widthHint = 0;
            this.heightHint = 0;
        } else if (this.axis.isHorizontalAxis()) {
            this.heightHint = 10;
        } else {
            this.widthHint = 10;
        }
    }

    public ChartLayoutData getLayoutData() {
        return new ChartLayoutData(this.widthHint, this.heightHint);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.bounds = new Rectangle(x, y, width, height);
    }

    protected Rectangle getBounds() {
        return this.bounds;
    }

    protected void dispose() {
        if (!this.chart.isDisposed()) {
            this.chart.removePaintListener(this);
        }
    }

    public void paintControl(PaintEvent e) {
        ArrayList<Integer> tickLabelPositions = this.axis.getTick().getAxisTickLabels().getTickLabelPositions();
        Color oldBackground = e.gc.getBackground();
        e.gc.setBackground(this.chart.getBackground());
        Color oldForeground = e.gc.getForeground();
        e.gc.setForeground(this.getForeground());
        Rectangle oldClipping = e.gc.getClipping();
        e.gc.setClipping(this.bounds);
        if (this.axis.isHorizontalAxis()) {
            this.drawXTickMarks(e.gc, tickLabelPositions, this.axis.getPosition());
        } else {
            this.drawYTickMarks(e.gc, tickLabelPositions, this.axis.getPosition());
        }
        e.gc.setClipping(oldClipping);
        e.gc.setBackground(oldBackground);
        e.gc.setForeground(oldForeground);
    }

    private void drawXTickMarks(GC gc, ArrayList<Integer> tickLabelPositions, IAxis.Position position) {
        gc.setLineStyle(1);
        if (this.axis.isValidCategoryAxis()) {
            if (tickLabelPositions.size() > 1) {
                int step = tickLabelPositions.get(1) - tickLabelPositions.get(0);
                int i = 0;
                while (i < tickLabelPositions.size() + 1) {
                    int x = i < tickLabelPositions.size() ? (int)((double)tickLabelPositions.get(i).intValue() - (double)step / 2.0) : (int)((double)tickLabelPositions.get(i - 1).intValue() + (double)step / 2.0);
                    int y = 0;
                    if (position == IAxis.Position.Secondary) {
                        y = this.bounds.height - 1 - 1 - 5;
                    }
                    gc.drawLine(this.bounds.x + x, this.bounds.y + y, this.bounds.x + x, this.bounds.y + y + 5);
                    ++i;
                }
            }
        } else {
            int i = 0;
            while (i < tickLabelPositions.size()) {
                int x = tickLabelPositions.get(i);
                int y = 0;
                if (position == IAxis.Position.Secondary) {
                    y = this.bounds.height - 1 - 1 - 5;
                }
                gc.drawLine(this.bounds.x + x, this.bounds.y + y, this.bounds.x + x, this.bounds.y + y + 5);
                ++i;
            }
        }
        if (position == IAxis.Position.Primary) {
            gc.drawLine(this.bounds.x, this.bounds.y, this.bounds.x + this.bounds.width - 1, this.bounds.y);
        } else {
            gc.drawLine(this.bounds.x, this.bounds.y + this.bounds.height - 1, this.bounds.x + this.bounds.width - 1, this.bounds.y + this.bounds.height - 1);
        }
    }

    private void drawYTickMarks(GC gc, ArrayList<Integer> tickLabelPositions, IAxis.Position position) {
        gc.setLineStyle(1);
        if (this.axis.isValidCategoryAxis()) {
            if (tickLabelPositions.size() > 1) {
                int step = tickLabelPositions.get(1) - tickLabelPositions.get(0);
                int i = 0;
                while (i < tickLabelPositions.size() + 1) {
                    int x = 0;
                    int y = i < tickLabelPositions.size() ? (int)((double)tickLabelPositions.get(i).intValue() - (double)step / 2.0) : (int)((double)tickLabelPositions.get(i - 1).intValue() + (double)step / 2.0);
                    x = position == IAxis.Position.Primary ? this.bounds.width - 1 - 1 - 5 : 1;
                    gc.drawLine(this.bounds.x + x, this.bounds.y + y, this.bounds.x + x + 5, this.bounds.y + y);
                    ++i;
                }
            }
        } else {
            int y = 0;
            int i = 0;
            while (i < tickLabelPositions.size()) {
                int x = 0;
                x = position == IAxis.Position.Primary ? this.bounds.width - 1 - 1 - 5 : 1;
                y = this.bounds.height - 1 - tickLabelPositions.get(i);
                gc.drawLine(this.bounds.x + x, this.bounds.y + y, this.bounds.x + x + 5, this.bounds.y + y);
                ++i;
            }
        }
        if (position == IAxis.Position.Primary) {
            gc.drawLine(this.bounds.x + this.bounds.width - 1, this.bounds.y, this.bounds.x + this.bounds.width - 1, this.bounds.y + this.bounds.height - 1);
        } else {
            gc.drawLine(this.bounds.x, this.bounds.y, this.bounds.x, this.bounds.y + this.bounds.height - 1);
        }
    }
}

