/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ml.neuralnet.sofm;

import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.ml.neuralnet.sofm.LearningFactorFunction;
import org.apache.commons.math3.ml.neuralnet.sofm.util.ExponentialDecayFunction;
import org.apache.commons.math3.ml.neuralnet.sofm.util.QuasiSigmoidDecayFunction;

public class LearningFactorFunctionFactory {
    private LearningFactorFunctionFactory() {
    }

    public static LearningFactorFunction exponentialDecay(double initValue, double valueAtNumCall, long numCall) {
        if (initValue <= 0.0 || initValue > 1.0) {
            throw new OutOfRangeException(initValue, (Number)0, 1);
        }
        return new LearningFactorFunction(initValue, valueAtNumCall, numCall){
            private final ExponentialDecayFunction decay;
            {
                this.decay = new ExponentialDecayFunction(d, d2, l);
            }

            @Override
            public double value(long n) {
                return this.decay.value(n);
            }
        };
    }

    public static LearningFactorFunction quasiSigmoidDecay(double initValue, double slope, long numCall) {
        if (initValue <= 0.0 || initValue > 1.0) {
            throw new OutOfRangeException(initValue, (Number)0, 1);
        }
        return new LearningFactorFunction(initValue, slope, numCall){
            private final QuasiSigmoidDecayFunction decay;
            {
                this.decay = new QuasiSigmoidDecayFunction(d, d2, l);
            }

            @Override
            public double value(long n) {
                return this.decay.value(n);
            }
        };
    }
}

