/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.identifier.supplier.manual.ui.handlers;

import javax.inject.Named;
import org.eclipse.chemclipse.chromatogram.xxd.identifier.supplier.manual.ui.internal.wizards.IdentificationWizard;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.csd.model.notifier.ChromatogramSelectionCSDUpdateNotifier;
import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.notifier.ChromatogramSelectionMSDUpdateNotifier;
import org.eclipse.chemclipse.progress.core.InfoType;
import org.eclipse.chemclipse.progress.core.StatusLineLogger;
import org.eclipse.chemclipse.rcp.app.ui.handlers.PerspectiveSwitchHandler;
import org.eclipse.chemclipse.wsd.model.core.selection.IChromatogramSelectionWSD;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class IdentifyPeakHandler
implements EventHandler {
    private static IChromatogramSelection chromatogramSelection;

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part) {
        if (chromatogramSelection != null) {
            if (chromatogramSelection instanceof IChromatogramSelectionMSD) {
                PerspectiveSwitchHandler.focusPerspectiveAndView((String)"org.eclipse.chemclipse.chromatogram.msd.perspective.ui.perspective.chromatogramPeaks", (String)"org.eclipse.chemclipse.ux.extension.msd.ui.part.peakTargetsView");
                final IChromatogramSelectionMSD chromatogramSelectionMSD = (IChromatogramSelectionMSD)chromatogramSelection;
                IChromatogramPeakMSD peakMSD = chromatogramSelectionMSD.getSelectedPeak();
                if (peakMSD != null) {
                    IdentificationWizard wizard = new IdentificationWizard((IPeak)peakMSD);
                    WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
                    if (dialog.open() == 0) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ChromatogramSelectionMSDUpdateNotifier.fireUpdateChange((IChromatogramSelectionMSD)chromatogramSelectionMSD, (boolean)true);
                            }
                        });
                        StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Done: Peak identified manually");
                    }
                }
            } else if (chromatogramSelection instanceof IChromatogramSelectionCSD) {
                PerspectiveSwitchHandler.focusPerspectiveAndView((String)"org.eclipse.chemclipse.ux.extension.csd.ui.perspective.main", (String)"org.eclipse.chemclipse.ux.extension.csd.ui.part.peakTargetsView");
                final IChromatogramSelectionCSD chromatogramSelectionFID = (IChromatogramSelectionCSD)chromatogramSelection;
                IChromatogramPeakCSD peakFID = chromatogramSelectionFID.getSelectedPeak();
                if (peakFID != null) {
                    IdentificationWizard wizard = new IdentificationWizard((IPeak)peakFID);
                    WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
                    if (dialog.open() == 0) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ChromatogramSelectionCSDUpdateNotifier.fireUpdateChange((IChromatogramSelectionCSD)chromatogramSelectionFID, (boolean)true);
                            }
                        });
                        StatusLineLogger.setInfo((InfoType)InfoType.MESSAGE, (String)"Done: Peak identified manually");
                    }
                }
            }
        }
    }

    public void handleEvent(Event event) {
        chromatogramSelection = event.getTopic().equals("chromatogram/msd/update/chromatogramselection") ? (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection") : (event.getTopic().equals("chromatogram/csd/update/chromatogramselection") ? (IChromatogramSelectionCSD)event.getProperty("ChromatogramSelection") : (event.getTopic().equals("chromatogram/wsd/update/chromatogramselection") ? (IChromatogramSelectionWSD)event.getProperty("ChromatogramSelection") : null));
    }
}

