/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.internal.provider;

import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.support.ui.swt.EnhancedViewerSorter;
import org.eclipse.jface.viewers.Viewer;

public class OverlaySettingsTableSorter
extends EnhancedViewerSorter {
    private int propertyIndex = 0;
    private static final int ASCENDING = 0;
    private int direction = 0;

    public void setColumn(int column) {
        if (column == this.propertyIndex) {
            this.direction = 1 - this.direction;
        } else {
            this.propertyIndex = column;
            this.direction = 0;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int sortOrder = 0;
        if (e1 instanceof IChromatogramSelection && e2 instanceof IChromatogramSelection) {
            IChromatogramSelection chromatogramSelection1 = (IChromatogramSelection)e1;
            IChromatogramSelection chromatogramSelection2 = (IChromatogramSelection)e2;
            switch (this.propertyIndex) {
                case 0: {
                    sortOrder = chromatogramSelection2.getChromatogram().getName().compareTo(chromatogramSelection1.getChromatogram().getName());
                    break;
                }
                case 1: {
                    sortOrder = Boolean.compare(chromatogramSelection2.isOverlaySelected(), chromatogramSelection1.isOverlaySelected());
                    break;
                }
                case 2: {
                    sortOrder = Boolean.compare(chromatogramSelection2.isLockOffset(), chromatogramSelection1.isLockOffset());
                    break;
                }
                default: {
                    sortOrder = 0;
                }
            }
        }
        if (this.direction == 0) {
            sortOrder = -sortOrder;
        }
        return sortOrder;
    }
}

