/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.internal.io;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.ZipFile;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IMethod;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.core.RetentionIndexType;
import org.eclipse.chemclipse.support.history.EditInformation;
import org.eclipse.chemclipse.support.history.IEditHistory;
import org.eclipse.chemclipse.support.history.IEditInformation;
import org.eclipse.chemclipse.wsd.converter.io.IChromatogramWSDReader;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.internal.io.AbstractChromatogramReader;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.model.chromatogram.VendorChromatogram;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.model.chromatogram.VendorScan;
import org.eclipse.chemclipse.wsd.converter.supplier.chemclipse.model.chromatogram.VendorScanSignal;
import org.eclipse.chemclipse.wsd.model.core.IChromatogramWSD;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.BaselineElement;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.IBaselineElement;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramReader_1007
extends AbstractChromatogramReader
implements IChromatogramWSDReader {
    public IChromatogramOverview readOverview(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        IChromatogramOverview chromatogramOverview = null;
        try (ZipFile zipFile = new ZipFile(file);){
            if (this.isValidFileFormat(zipFile)) {
                chromatogramOverview = this.readOverviewFromZipFile(zipFile, monitor);
            }
        }
        return chromatogramOverview;
    }

    private IChromatogramOverview readOverviewFromZipFile(ZipFile zipFile, IProgressMonitor monitor) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "WSD/OVERVIEW/TIC");
        VendorChromatogram chromatogram = new VendorChromatogram();
        this.readScansOverview(dataInputStream, chromatogram, monitor);
        dataInputStream.close();
        return chromatogram;
    }

    private void readScansOverview(DataInputStream dataInputStream, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        int scans = dataInputStream.readInt();
        int scan = 1;
        while (scan <= scans) {
            monitor.subTask("Import Scan: " + scan);
            VendorScan scanObject = new VendorScan();
            int scanSignals = dataInputStream.readInt();
            int scanSignal = 0;
            while (scanSignal < scanSignals) {
                VendorScanSignal scanSignalObject = new VendorScanSignal();
                int wavelength = dataInputStream.readInt();
                float abundance = dataInputStream.readFloat();
                scanSignalObject.setWavelength(wavelength);
                scanSignalObject.setAbundance(abundance);
                scanObject.addScanSignal(scanSignalObject);
                ++scanSignal;
            }
            int retentionTime = dataInputStream.readInt();
            float retentionIndex = dataInputStream.readFloat();
            float totalSignal = dataInputStream.readFloat();
            int timeSegmentId = dataInputStream.readInt();
            int cycleNumber = dataInputStream.readInt();
            scanObject.setRetentionTime(retentionTime);
            scanObject.setRetentionIndex(retentionIndex);
            scanObject.setTimeSegmentId(timeSegmentId);
            scanObject.setCycleNumber(cycleNumber);
            scanObject.adjustTotalSignal(totalSignal);
            chromatogram.addScan((IScan)scanObject);
            ++scan;
        }
    }

    public IChromatogramWSD read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        IChromatogramWSD chromatogram = null;
        try (ZipFile zipFile = new ZipFile(file);){
            if (this.isValidFileFormat(zipFile)) {
                monitor.subTask("Import Chromatogram");
                chromatogram = this.readFromZipFile(zipFile, file, monitor);
            }
        }
        return chromatogram;
    }

    private IChromatogramWSD readFromZipFile(ZipFile zipFile, File file, IProgressMonitor monitor) throws IOException {
        VendorChromatogram chromatogram = new VendorChromatogram();
        this.readMethod(zipFile, chromatogram, monitor);
        this.readScans(zipFile, chromatogram, monitor);
        this.readBaselines(zipFile, chromatogram, monitor);
        this.readHistory(zipFile, chromatogram, monitor);
        this.readMiscellaneous(zipFile, chromatogram, monitor);
        return chromatogram;
    }

    private void readMethod(ZipFile zipFile, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "WSD/CHROMATOGRAM/SYSTEM_SETTINGS");
        IMethod method = chromatogram.getMethod();
        method.setInstrumentName(this.readString(dataInputStream));
        method.setIonSource(this.readString(dataInputStream));
        method.setSamplingRate(dataInputStream.readDouble());
        method.setSolventDelay(dataInputStream.readInt());
        method.setSourceHeater(dataInputStream.readDouble());
        method.setStopMode(this.readString(dataInputStream));
        method.setStopTime(dataInputStream.readInt());
        method.setTimeFilterPeakWidth(dataInputStream.readInt());
        dataInputStream.close();
    }

    private void readScans(ZipFile zipFile, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "WSD/CHROMATOGRAM/SCANS");
        int scans = dataInputStream.readInt();
        int scan = 1;
        while (scan <= scans) {
            monitor.subTask("Import Scan: " + scan);
            VendorScan scanWSD = new VendorScan();
            int scanSignals = dataInputStream.readInt();
            int scanSignal = 0;
            while (scanSignal < scanSignals) {
                VendorScanSignal scanSignalObject = new VendorScanSignal();
                int wavelength = dataInputStream.readInt();
                float abundance = dataInputStream.readFloat();
                scanSignalObject.setWavelength(wavelength);
                scanSignalObject.setAbundance(abundance);
                scanWSD.addScanSignal(scanSignalObject);
                ++scanSignal;
            }
            int retentionTime = dataInputStream.readInt();
            int retentionTimeColumn1 = dataInputStream.readInt();
            int retentionTimeColumn2 = dataInputStream.readInt();
            float retentionIndex = dataInputStream.readFloat();
            if (dataInputStream.readBoolean()) {
                int size = dataInputStream.readInt();
                int i = 0;
                while (i < size) {
                    RetentionIndexType retentionIndexType = RetentionIndexType.valueOf((String)this.readString(dataInputStream));
                    float retentionIndexAdditional = dataInputStream.readFloat();
                    scanWSD.setRetentionIndex(retentionIndexType, retentionIndexAdditional);
                    ++i;
                }
            }
            float totalSignal = dataInputStream.readFloat();
            int timeSegmentId = dataInputStream.readInt();
            int cycleNumber = dataInputStream.readInt();
            scanWSD.setRetentionTime(retentionTime);
            scanWSD.setRetentionTimeColumn1(retentionTimeColumn1);
            scanWSD.setRetentionTimeColumn2(retentionTimeColumn2);
            scanWSD.setRetentionIndex(retentionIndex);
            scanWSD.setTimeSegmentId(timeSegmentId);
            scanWSD.setCycleNumber(cycleNumber);
            scanWSD.adjustTotalSignal(totalSignal);
            chromatogram.addScan((IScan)scanWSD);
            ++scan;
        }
        dataInputStream.close();
    }

    private void readBaselines(ZipFile zipFile, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "WSD/CHROMATOGRAM/BASELINE");
        int scans = dataInputStream.readInt();
        ArrayList<BaselineElement> baselineElements = new ArrayList<BaselineElement>();
        int scan = 1;
        while (scan <= scans) {
            monitor.subTask("Import Scan: " + scan);
            int retentionTime = dataInputStream.readInt();
            float backgroundAbundance = dataInputStream.readFloat();
            BaselineElement baselineElement = new BaselineElement(retentionTime, backgroundAbundance);
            baselineElements.add(baselineElement);
            ++scan;
        }
        IBaselineModel baselineModel = chromatogram.getBaselineModel();
        int index = 0;
        while (index < scans - 1) {
            monitor.subTask("Import Baseline: " + index);
            IBaselineElement baselineElement = (IBaselineElement)baselineElements.get(index);
            IBaselineElement baselineElementNext = (IBaselineElement)baselineElements.get(index + 1);
            int startRetentionTime = baselineElement.getRetentionTime();
            float startBackgroundAbundance = baselineElement.getBackgroundAbundance();
            int stopRetentionTime = baselineElementNext.getRetentionTime();
            float stopBackgroundAbundance = baselineElementNext.getBackgroundAbundance();
            baselineModel.addBaseline(startRetentionTime, stopRetentionTime, startBackgroundAbundance, stopBackgroundAbundance, false);
            ++index;
        }
        dataInputStream.close();
    }

    private void readHistory(ZipFile zipFile, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "WSD/CHROMATOGRAM/HISTORY");
        IEditHistory editHistory = chromatogram.getEditHistory();
        int numEntries = dataInputStream.readInt();
        int i = 1;
        while (i <= numEntries) {
            long time = dataInputStream.readLong();
            String description = this.readString(dataInputStream);
            Date date = new Date(time);
            EditInformation editInformation = new EditInformation(date, description);
            editHistory.add((IEditInformation)editInformation);
            ++i;
        }
        dataInputStream.close();
    }

    private void readMiscellaneous(ZipFile zipFile, IChromatogramWSD chromatogram, IProgressMonitor monitor) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "WSD/CHROMATOGRAM/MISC");
        long time = dataInputStream.readLong();
        String miscInfo = this.readString(dataInputStream);
        String miscInfoSeparated = this.readString(dataInputStream);
        String dataName = this.readString(dataInputStream);
        String operator = this.readString(dataInputStream);
        Date date = new Date(time);
        chromatogram.setDate(date);
        chromatogram.setMiscInfo(miscInfo);
        chromatogram.setMiscInfoSeparated(miscInfoSeparated);
        chromatogram.setDataName(dataName);
        chromatogram.setOperator(operator);
        dataInputStream.close();
    }

    private boolean isValidFileFormat(ZipFile zipFile) throws IOException {
        boolean isValid = false;
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "VERSION");
        String version = this.readString(dataInputStream);
        if (version.equals("1.0.0.7")) {
            isValid = true;
        }
        dataInputStream.close();
        return isValid;
    }
}

