/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;
import org.eclipse.chemclipse.converter.exceptions.FileIsEmptyException;
import org.eclipse.chemclipse.converter.exceptions.FileIsNotReadableException;
import org.eclipse.chemclipse.csd.converter.io.IChromatogramCSDReader;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.internal.io.AbstractChromatogramReader;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.model.chromatogram.VendorChromatogram;
import org.eclipse.chemclipse.csd.converter.supplier.chemclipse.model.chromatogram.VendorScan;
import org.eclipse.chemclipse.csd.model.core.IChromatogramCSD;
import org.eclipse.chemclipse.csd.model.core.IChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.core.IPeakModelCSD;
import org.eclipse.chemclipse.csd.model.implementation.ChromatogramPeakCSD;
import org.eclipse.chemclipse.csd.model.implementation.IntegrationEntryCSD;
import org.eclipse.chemclipse.csd.model.implementation.PeakModelCSD;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.baseline.IBaselineModel;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.model.core.IIntegrationEntry;
import org.eclipse.chemclipse.model.core.IMethod;
import org.eclipse.chemclipse.model.core.IPeakIntensityValues;
import org.eclipse.chemclipse.model.core.IScan;
import org.eclipse.chemclipse.model.core.PeakType;
import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.model.implementation.PeakIntensityValues;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.BaselineElement;
import org.eclipse.chemclipse.xxd.converter.supplier.chemclipse.internal.support.IBaselineElement;
import org.eclipse.core.runtime.IProgressMonitor;

public class ChromatogramReader_1005
extends AbstractChromatogramReader
implements IChromatogramCSDReader {
    private static final Logger logger = Logger.getLogger(ChromatogramReader_1005.class);

    public IChromatogramOverview readOverview(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        return this.readChromatogram(file, monitor);
    }

    public IChromatogramCSD read(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        return this.readChromatogram(file, monitor);
    }

    private IChromatogramCSD readChromatogram(File file, IProgressMonitor monitor) throws FileNotFoundException, FileIsNotReadableException, FileIsEmptyException, IOException {
        VendorChromatogram chromatogram = null;
        try (ZipFile zipFile = new ZipFile(file);){
            if (this.isValidFileFormat(zipFile)) {
                monitor.subTask("Import Chromatogram");
                chromatogram = new VendorChromatogram();
                this.readMethod(zipFile, chromatogram, monitor);
                this.readScans(zipFile, chromatogram, monitor);
                this.readBaseline(zipFile, chromatogram, monitor);
                this.readPeaks(zipFile, chromatogram, monitor);
                this.setAdditionalInformation(file, chromatogram, monitor);
            }
        }
        return chromatogram;
    }

    private void readMethod(ZipFile zipFile, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "FID/CHROMATOGRAM/SYSTEM_SETTINGS");
        IMethod method = chromatogram.getMethod();
        method.setInstrumentName(this.readString(dataInputStream));
        method.setIonSource(this.readString(dataInputStream));
        method.setSamplingRate(dataInputStream.readDouble());
        method.setSolventDelay(dataInputStream.readInt());
        method.setSourceHeater(dataInputStream.readDouble());
        method.setStopMode(this.readString(dataInputStream));
        method.setStopTime(dataInputStream.readInt());
        method.setTimeFilterPeakWidth(dataInputStream.readInt());
        dataInputStream.close();
    }

    private void readScans(ZipFile zipFile, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "FID/CHROMATOGRAM/SCANS");
        int scans = dataInputStream.readInt();
        int scan = 1;
        while (scan <= scans) {
            monitor.subTask("Import Scan: " + scan);
            int retentionTime = dataInputStream.readInt();
            float retentionIndex = dataInputStream.readFloat();
            float totalSignal = dataInputStream.readFloat();
            int timeSegmentId = dataInputStream.readInt();
            int cycleNumber = dataInputStream.readInt();
            VendorScan scanFID = new VendorScan(retentionTime, totalSignal);
            scanFID.setRetentionIndex(retentionIndex);
            scanFID.setTimeSegmentId(timeSegmentId);
            scanFID.setCycleNumber(cycleNumber);
            chromatogram.addScan((IScan)scanFID);
            ++scan;
        }
        dataInputStream.close();
    }

    private void readBaseline(ZipFile zipFile, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "FID/CHROMATOGRAM/BASELINE");
        int scans = dataInputStream.readInt();
        ArrayList<BaselineElement> baselineElements = new ArrayList<BaselineElement>();
        int scan = 1;
        while (scan <= scans) {
            monitor.subTask("Import Baseline: " + scan);
            int retentionTime = dataInputStream.readInt();
            float backgroundAbundance = dataInputStream.readFloat();
            BaselineElement baselineElement = new BaselineElement(retentionTime, backgroundAbundance);
            baselineElements.add(baselineElement);
            ++scan;
        }
        IBaselineModel baselineModel = chromatogram.getBaselineModel();
        int index = 0;
        while (index < scans - 1) {
            IBaselineElement baselineElement = (IBaselineElement)baselineElements.get(index);
            IBaselineElement baselineElementNext = (IBaselineElement)baselineElements.get(index + 1);
            int startRetentionTime = baselineElement.getRetentionTime();
            float startBackgroundAbundance = baselineElement.getBackgroundAbundance();
            int stopRetentionTime = baselineElementNext.getRetentionTime();
            float stopBackgroundAbundance = baselineElementNext.getBackgroundAbundance();
            baselineModel.addBaseline(startRetentionTime, stopRetentionTime, startBackgroundAbundance, stopBackgroundAbundance, false);
            ++index;
        }
        dataInputStream.close();
    }

    private void readPeaks(ZipFile zipFile, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "FID/CHROMATOGRAM/PEAKS");
        int numberOfPeaks = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfPeaks) {
            monitor.subTask("Import Peak: " + i);
            try {
                IChromatogramPeakCSD peak = this.readPeak(dataInputStream, chromatogram, monitor);
                chromatogram.addPeak(peak);
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)e);
            }
            catch (PeakException e) {
                logger.warn((Object)e);
            }
            ++i;
        }
        dataInputStream.close();
    }

    private IChromatogramPeakCSD readPeak(DataInputStream dataInputStream, IChromatogramCSD chromatogram, IProgressMonitor monitor) throws IOException, IllegalArgumentException, PeakException {
        String detectorDescription = this.readString(dataInputStream);
        String integratorDescription = this.readString(dataInputStream);
        String modelDescription = this.readString(dataInputStream);
        PeakType peakType = PeakType.valueOf((String)this.readString(dataInputStream));
        int suggestedNumberOfComponents = dataInputStream.readInt();
        float startBackgroundAbundance = dataInputStream.readFloat();
        float stopBackgroundAbundance = dataInputStream.readFloat();
        int retentionTimeScan = dataInputStream.readInt();
        float retentionIndexScan = dataInputStream.readFloat();
        float totalSignalScan = dataInputStream.readFloat();
        int timeSegmentId = dataInputStream.readInt();
        int cycleNumber = dataInputStream.readInt();
        VendorScan peakMaximum = new VendorScan(retentionTimeScan, totalSignalScan);
        peakMaximum.setRetentionIndex(retentionIndexScan);
        peakMaximum.setTimeSegmentId(timeSegmentId);
        peakMaximum.setCycleNumber(cycleNumber);
        int numberOfRetentionTimes = dataInputStream.readInt();
        PeakIntensityValues intensityValues = new PeakIntensityValues(Float.MAX_VALUE);
        int i = 1;
        while (i <= numberOfRetentionTimes) {
            int retentionTime = dataInputStream.readInt();
            float relativeIntensity = dataInputStream.readFloat();
            intensityValues.addIntensityValue(retentionTime, relativeIntensity);
            ++i;
        }
        intensityValues.normalize();
        PeakModelCSD peakModel = new PeakModelCSD((IScan)peakMaximum, (IPeakIntensityValues)intensityValues, startBackgroundAbundance, stopBackgroundAbundance);
        ChromatogramPeakCSD peak = new ChromatogramPeakCSD((IPeakModelCSD)peakModel, chromatogram);
        peak.setDetectorDescription(detectorDescription);
        peak.setIntegratorDescription(integratorDescription);
        peak.setModelDescription(modelDescription);
        peak.setPeakType(peakType);
        peak.setSuggestedNumberOfComponents(suggestedNumberOfComponents);
        List<IIntegrationEntry> integrationEntries = this.readIntegrationEntries(dataInputStream);
        peak.setIntegratedArea(integrationEntries, integratorDescription);
        return peak;
    }

    private void setAdditionalInformation(File file, IChromatogramCSD chromatogram, IProgressMonitor monitor) {
        int startRetentionTime;
        chromatogram.setConverterId("org.eclipse.chemclipse.xxd.converter.supplier.chemclipse");
        chromatogram.setFile(file);
        int scanDelay = startRetentionTime = chromatogram.getStartRetentionTime();
        chromatogram.setScanDelay(scanDelay);
        int endRetentionTime = chromatogram.getStopRetentionTime();
        int scanInterval = endRetentionTime / chromatogram.getNumberOfScans();
        chromatogram.setScanInterval(scanInterval);
    }

    private List<IIntegrationEntry> readIntegrationEntries(DataInputStream dataInputStream) throws IOException {
        ArrayList<IIntegrationEntry> integrationEntries = new ArrayList<IIntegrationEntry>();
        int numberOfIntegrationEntries = dataInputStream.readInt();
        int i = 1;
        while (i <= numberOfIntegrationEntries) {
            double integratedArea = dataInputStream.readDouble();
            IntegrationEntryCSD integrationEntry = new IntegrationEntryCSD(integratedArea);
            integrationEntries.add((IIntegrationEntry)integrationEntry);
            ++i;
        }
        return integrationEntries;
    }

    private boolean isValidFileFormat(ZipFile zipFile) throws IOException {
        boolean isValid = false;
        DataInputStream dataInputStream = this.getDataInputStream(zipFile, "VERSION");
        String version = this.readString(dataInputStream);
        if (version.equals("1.0.0.5")) {
            isValid = true;
        }
        dataInputStream.close();
        return isValid;
    }
}

