/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.implementation;

import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.model.exceptions.AbundanceLimitExceededException;
import org.eclipse.chemclipse.msd.model.core.AbstractRegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IIon;
import org.eclipse.chemclipse.msd.model.core.IRegularLibraryMassSpectrum;
import org.eclipse.chemclipse.msd.model.exceptions.IonLimitExceededException;
import org.eclipse.chemclipse.msd.model.implementation.Ion;

public class RegularLibraryMassSpectrum
extends AbstractRegularLibraryMassSpectrum {
    private static final Logger logger = Logger.getLogger(RegularLibraryMassSpectrum.class);
    private static final long serialVersionUID = 5138492745628996885L;

    @Override
    public IRegularLibraryMassSpectrum makeDeepCopy() throws CloneNotSupportedException {
        IRegularLibraryMassSpectrum massSpectrum = (IRegularLibraryMassSpectrum)super.clone();
        for (IIon ion : this.getIons()) {
            try {
                Ion defaultIon = new Ion(ion.getIon(), ion.getAbundance());
                massSpectrum.addIon(defaultIon);
            }
            catch (AbundanceLimitExceededException e) {
                logger.warn((Object)e);
            }
            catch (IonLimitExceededException e) {
                logger.warn((Object)e);
            }
        }
        return massSpectrum;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return this.makeDeepCopy();
    }
}

