/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.rcp.app.ui.dialogs;

import org.eclipse.chemclipse.rcp.app.ui.internal.preferences.PreferenceSupplier;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class PerspectiveChooserDialog
extends Dialog {
    private String title = "";
    private String message = "";
    private Label messageLabel;
    private Button showPerspectiveDialog;
    private Button changePerspectiveAutomatically;

    public PerspectiveChooserDialog(Shell parentShell, String title, String message) {
        super(parentShell);
        if (title != null) {
            this.title = title;
        }
        if (message != null) {
            this.message = message;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            PreferenceSupplier.setShowPerspectiveDialog(this.showPerspectiveDialog.getSelection());
            PreferenceSupplier.setChangePerspectiveAutomatically(this.changePerspectiveAutomatically.getSelection());
        }
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData layoutData = new GridData(1796);
        layoutData.widthHint = this.convertHorizontalDLUsToPixels(300);
        this.createMessage(composite);
        this.createCheckboxes(composite, layoutData);
        return composite;
    }

    private void createMessage(Composite parent) {
        if (this.message != null) {
            GridData layoutData = new GridData(1796);
            layoutData.widthHint = this.convertHorizontalDLUsToPixels(300);
            layoutData.minimumHeight = 100;
            this.messageLabel = new Label(parent, 64);
            this.messageLabel.setLayoutData((Object)layoutData);
            this.messageLabel.setText(this.message);
            this.messageLabel.setFont(parent.getFont());
        }
    }

    private void createCheckboxes(Composite parent, GridData layoutData) {
        this.showPerspectiveDialog = new Button(parent, 32);
        this.showPerspectiveDialog.setText("Show this dialog.");
        this.showPerspectiveDialog.setLayoutData((Object)layoutData);
        this.showPerspectiveDialog.setSelection(PreferenceSupplier.getShowPerspectiveDialog());
        this.changePerspectiveAutomatically = new Button(parent, 32);
        this.changePerspectiveAutomatically.setText("Change perspectives and views automatically.");
        this.changePerspectiveAutomatically.setLayoutData((Object)layoutData);
        this.changePerspectiveAutomatically.setSelection(PreferenceSupplier.getChangePerspectiveAutomatically());
    }
}

