/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import java.util.Map;
import org.eclipse.core.databinding.beans.IBeanMapProperty;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.map.IMapProperty;
import org.eclipse.core.databinding.property.map.MapProperty;
import org.eclipse.core.internal.databinding.beans.BeanObservableMapDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoMapPropertyDecorator<S, K, V>
extends MapProperty<S, K, V>
implements IBeanMapProperty<S, K, V> {
    private final IMapProperty<S, K, V> delegate;
    private final PropertyDescriptor propertyDescriptor;

    public PojoMapPropertyDecorator(IMapProperty<S, K, V> delegate, PropertyDescriptor propertyDescriptor) {
        this.delegate = delegate;
        this.propertyDescriptor = propertyDescriptor;
    }

    public Object getKeyType() {
        return this.delegate.getKeyType();
    }

    public Object getValueType() {
        return this.delegate.getValueType();
    }

    public Class<K> getKeyClass() {
        return this.delegate.getKeyClass();
    }

    public Class<V> getValueClass() {
        return this.delegate.getValueClass();
    }

    protected Map<K, V> doGetMap(S source) {
        return this.delegate.getMap(source);
    }

    protected void doSetMap(S source, Map<K, V> map) {
        this.delegate.setMap(source, map);
    }

    protected void doUpdateMap(S source, MapDiff<K, V> diff) {
        this.delegate.updateMap(source, diff);
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    @Override
    public <T> IBeanMapProperty<S, K, T> values(String propertyName) {
        return this.values(propertyName, (Class<T>)null);
    }

    @Override
    public <T> IBeanMapProperty<S, K, T> values(String propertyName, Class<T> valueType) {
        Class beanClass = this.delegate.getValueClass();
        return this.values(PojoProperties.value(beanClass, propertyName, valueType));
    }

    @Override
    public <T> IBeanMapProperty<S, K, T> values(IBeanValueProperty<V, T> property) {
        return new PojoMapPropertyDecorator<S, K, V>(super.values(property), property.getPropertyDescriptor());
    }

    public IObservableMap<K, V> observe(S source) {
        return new BeanObservableMapDecorator(this.delegate.observe(source), this.propertyDescriptor);
    }

    public IObservableMap<K, V> observe(Realm realm, S source) {
        return new BeanObservableMapDecorator(this.delegate.observe(realm, source), this.propertyDescriptor);
    }

    public <M extends S> IObservableMap<K, V> observeDetail(IObservableValue<M> master) {
        return new BeanObservableMapDecorator(this.delegate.observeDetail(master), this.propertyDescriptor);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

