/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.swt.ui.components.chromatogram;

import org.eclipse.chemclipse.model.core.IPeak;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.swt.ui.components.AbstractChromatogramLineSeriesUI;
import org.eclipse.chemclipse.swt.ui.converter.SeriesConverter;
import org.eclipse.chemclipse.swt.ui.series.ISeries;
import org.eclipse.chemclipse.swt.ui.support.AxisTitlesIntensityScale;
import org.eclipse.chemclipse.swt.ui.support.Colors;
import org.eclipse.chemclipse.swt.ui.support.Sign;
import org.eclipse.swt.widgets.Composite;
import org.swtchart.ILineSeries;
import org.swtchart.ISeries;

public class SelectedPeakChromatogramUI
extends AbstractChromatogramLineSeriesUI {
    public SelectedPeakChromatogramUI(Composite parent, int style) {
        super(parent, style, new AxisTitlesIntensityScale());
    }

    @Override
    public void setViewSeries() {
        IChromatogramSelection chromatogramSelection = this.getChromatogramSelection();
        ISeries series = SeriesConverter.convertChromatogram(chromatogramSelection, Sign.POSITIVE, true);
        this.addSeries(series);
        ILineSeries lineSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
        lineSeries.setXSeries(series.getXSeries());
        lineSeries.setYSeries(series.getYSeries());
        lineSeries.enableArea(true);
        lineSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
        lineSeries.setLineColor(Colors.GRAY);
        IPeak peak = chromatogramSelection.getSelectedPeak();
        if (peak != null) {
            series = SeriesConverter.convertSelectedPeak(peak, true, Sign.POSITIVE);
            ILineSeries peakSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
            peakSeries.setXSeries(series.getXSeries());
            peakSeries.setYSeries(series.getYSeries());
            peakSeries.enableArea(true);
            peakSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
            peakSeries.setLineColor(Colors.RED);
            series = SeriesConverter.convertSelectedPeakBackground(peak, Sign.POSITIVE);
            ILineSeries backgroundSeries = (ILineSeries)this.getSeriesSet().createSeries(ISeries.SeriesType.LINE, series.getId());
            backgroundSeries.setXSeries(series.getXSeries());
            backgroundSeries.setYSeries(series.getYSeries());
            backgroundSeries.enableArea(true);
            backgroundSeries.setSymbolType(ILineSeries.PlotSymbolType.NONE);
            backgroundSeries.setLineColor(Colors.BLACK);
        }
    }
}

