/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.views;

import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.ux.extension.msd.ui.views.IChromatogramSelectionMSDView;
import org.eclipse.chemclipse.ux.extension.ui.definitions.ChromatogramType;
import org.eclipse.chemclipse.ux.extension.ui.explorer.AbstractSelectionView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class AbstractChromatogramSelectionMSDView
extends AbstractSelectionView
implements IChromatogramSelectionMSDView {
    private IChromatogramSelectionMSD chromatogramSelection;
    private IEventBroker eventBroker;
    private EventHandler eventHandler;

    public AbstractChromatogramSelectionMSDView(MPart part, EPartService partService, IEventBroker eventBroker) {
        super(part, partService);
        this.eventBroker = eventBroker;
        this.subscribe();
    }

    @Override
    public IChromatogramSelectionMSD getChromatogramSelection() {
        if (this.chromatogramSelection == null) {
            this.chromatogramSelection = ChromatogramType.getChromatogramSelectionMSD();
        }
        return this.chromatogramSelection;
    }

    @Override
    public void setChromatogramSelection(IChromatogramSelectionMSD chromatogramSelection) {
        this.chromatogramSelection = chromatogramSelection;
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    AbstractChromatogramSelectionMSDView.this.chromatogramSelection = (IChromatogramSelectionMSD)event.getProperty("ChromatogramSelection");
                    boolean forceReload = (Boolean)event.getProperty("ForceReload");
                    AbstractChromatogramSelectionMSDView.this.update(AbstractChromatogramSelectionMSDView.this.chromatogramSelection, forceReload);
                }
            };
            this.eventBroker.subscribe("chromatogram/msd/update/chromatogramselection", this.eventHandler);
        }
    }

    public void unsubscribe() {
        if (this.eventBroker != null && this.eventHandler != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }

    @Override
    public boolean doUpdate(IChromatogramSelection chromatogramSelection) {
        return super.doUpdate((Object)chromatogramSelection);
    }
}

