/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.msd.ui.support;

import java.io.File;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.msd.converter.chromatogram.ChromatogramConverterMSD;
import org.eclipse.chemclipse.ux.extension.ui.provider.AbstractChromatogramEditorSupport;
import org.eclipse.chemclipse.ux.extension.ui.provider.IChromatogramEditorSupport;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class ChromatogramEditorSupport
extends AbstractChromatogramEditorSupport
implements IChromatogramEditorSupport {
    public ChromatogramEditorSupport() {
        super(ChromatogramConverterMSD.getChromatogramConverterSupport().getSupplier());
    }

    public String getType() {
        return "MSD";
    }

    public void openEditor(File file, EModelService modelService, MApplication application, EPartService partService) {
        if (this.isChromatogram(file) || this.isChromatogramDirectory(file)) {
            this.modelService = modelService;
            this.application = application;
            this.partService = partService;
            this.openEditor(file, null, "org.eclipse.chemclipse.ux.extension.msd.ui.part.chromatogramEditor", "bundleclass://org.eclipse.chemclipse.ux.extension.msd.ui/org.eclipse.chemclipse.ux.extension.msd.ui.editors.ChromatogramEditorMSD", "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/chromatogram.gif", "Chromatogram - Detector Type: MSD");
        }
    }

    public void openEditor(IChromatogram chromatogram, EModelService modelService, MApplication application, EPartService partService) {
        this.modelService = modelService;
        this.application = application;
        this.partService = partService;
        this.openEditor(null, chromatogram, "org.eclipse.chemclipse.ux.extension.msd.ui.part.chromatogramEditor", "bundleclass://org.eclipse.chemclipse.ux.extension.msd.ui/org.eclipse.chemclipse.ux.extension.msd.ui.editors.ChromatogramEditorMSD", "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/chromatogram.gif", "Chromatogram - Detector Type: MSD");
    }

    public void openOverview(File file, IEventBroker eventBroker) {
        if (this.isChromatogram(file) || this.isChromatogramDirectory(file)) {
            eventBroker.send("chromatogram/msd/update/rawfile", (Object)file);
        }
    }

    public void openOverview(IChromatogramOverview chromatogramOverview, IEventBroker eventBroker) {
        eventBroker.send("chromatogram/msd/update/overview", (Object)chromatogramOverview);
    }
}

