/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.msd.model.core;

import org.eclipse.chemclipse.model.exceptions.PeakException;
import org.eclipse.chemclipse.msd.model.core.AbstractPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramMSD;
import org.eclipse.chemclipse.msd.model.core.IChromatogramPeakMSD;
import org.eclipse.chemclipse.msd.model.core.IPeakMassSpectrum;
import org.eclipse.chemclipse.msd.model.core.IPeakModelMSD;
import org.eclipse.chemclipse.msd.model.core.IScanMSD;

public abstract class AbstractChromatogramPeakMSD
extends AbstractPeakMSD
implements IChromatogramPeakMSD {
    private static final long serialVersionUID = 7031247154782115765L;
    private transient IChromatogramMSD chromatogram;
    private static final float INITIAL_SN_VALUE = -1.0f;
    private float signalToNoiseRatio = -1.0f;

    public AbstractChromatogramPeakMSD(IPeakModelMSD peakModel, IChromatogramMSD chromatogram) throws IllegalArgumentException, PeakException {
        super(peakModel);
        this.validateChromatogram(chromatogram);
        this.validateRetentionTimes(chromatogram, peakModel);
        this.chromatogram = chromatogram;
    }

    public AbstractChromatogramPeakMSD(IPeakModelMSD peakModel, IChromatogramMSD chromatogram, String modelDescription) throws IllegalArgumentException, PeakException {
        this(peakModel, chromatogram);
        this.setModelDescription(modelDescription);
    }

    @Override
    public IScanMSD getChromatogramMassSpectrum() {
        return this.chromatogram.getSupplierScan(this.getScanMax());
    }

    @Override
    public float getBackgroundAbundanceAtScan(int scan) {
        if (scan >= 1 && scan <= this.chromatogram.getNumberOfScans()) {
            int retentionTime = this.chromatogram.getScan(scan).getRetentionTime();
            return this.getPeakModel().getBackgroundAbundance(retentionTime);
        }
        return 0.0f;
    }

    @Override
    public IChromatogramMSD getChromatogram() {
        return this.chromatogram;
    }

    @Override
    public float getPeakAbundanceAtScan(int scan) {
        int retentionTime = this.chromatogram.getScan(scan).getRetentionTime();
        return this.getPeakModel().getPeakAbundance(retentionTime);
    }

    @Override
    public int getScanMax() {
        int retentionTime = this.getPeakModel().getRetentionTimeAtPeakMaximum();
        return this.chromatogram.getScanNumber(retentionTime);
    }

    @Override
    public float getSignalToNoiseRatio() {
        if (this.signalToNoiseRatio == -1.0f) {
            float totalSignal = this.getPeakModel().getPeakAbundance();
            this.signalToNoiseRatio = this.chromatogram.getSignalToNoiseRatio(totalSignal);
        }
        return this.signalToNoiseRatio;
    }

    @Override
    public int getWidthBaselineTotalInScans() {
        int start = this.chromatogram.getScanNumber(this.getPeakModel().getStartRetentionTime());
        if (start == 0) {
            return 0;
        }
        int stop = this.chromatogram.getScanNumber(this.getPeakModel().getStopRetentionTime());
        if (stop == 0) {
            return 0;
        }
        return stop - start + 1;
    }

    @Override
    public float getPurity() {
        int numberOfIons;
        float purity = 0.0f;
        IPeakMassSpectrum extractedMassSpectrum = this.getExtractedMassSpectrum();
        IScanMSD genuineMassSpectrum = this.getChromatogramMassSpectrum();
        if (extractedMassSpectrum != null && genuineMassSpectrum != null && (numberOfIons = genuineMassSpectrum.getNumberOfIons()) != 0) {
            purity = (float)extractedMassSpectrum.getNumberOfIons() / (float)numberOfIons;
        }
        return purity;
    }

    @Override
    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        AbstractChromatogramPeakMSD other = (AbstractChromatogramPeakMSD)otherObject;
        return this.getPeakModel().equals(other.getPeakModel()) && this.chromatogram == other.getChromatogram();
    }

    @Override
    public int hashCode() {
        return 7 * this.getPeakModel().hashCode() + 11 * this.chromatogram.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("[");
        builder.append("peakModel=" + this.getPeakModel());
        builder.append(",");
        builder.append("chromatogram=" + this.chromatogram);
        builder.append("]");
        return builder.toString();
    }
}

