/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.converter.io.support;

import org.eclipse.chemclipse.converter.io.support.IStructureResolver;

public class StructureResolver
implements IStructureResolver {
    @Override
    public String formatAsBinary(int value) {
        String binary = Integer.toBinaryString(value);
        String binaryPaddded = String.valueOf(this.getZeroBytes(32 - binary.length())) + binary;
        return this.format(binaryPaddded);
    }

    @Override
    public String formatAsBinary(long value) {
        String binary = Long.toBinaryString(value);
        String binaryPaddded = String.valueOf(this.getZeroBytes(64 - binary.length())) + binary;
        return this.format(binaryPaddded);
    }

    @Override
    public String formatAsBinary(float value) {
        return this.formatAsBinary(Float.floatToIntBits(value));
    }

    @Override
    public String formatAsBinary(double value) {
        return this.formatAsBinary(Double.doubleToLongBits(value));
    }

    private String format(String binaryPaddded) {
        char[] buffer = binaryPaddded.toCharArray();
        int size = buffer.length;
        StringBuilder builder = new StringBuilder();
        int i = 1;
        while (i <= size) {
            builder.append(buffer[i - 1]);
            if (i % 8 == 0 && i < size) {
                builder.append(" |");
            }
            if (i < size) {
                builder.append(" ");
            }
            ++i;
        }
        return builder.toString();
    }

    private String getZeroBytes(int size) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < size) {
            builder.append("0");
            ++i;
        }
        return builder.toString();
    }
}

