/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.mult;

import org.ejml.data.CDenseMatrix64F;
import org.ejml.data.Complex64F;

public class CVectorVectorMult {
    public static Complex64F innerProd(CDenseMatrix64F x, CDenseMatrix64F y, Complex64F output) {
        if (output == null) {
            output = new Complex64F();
        } else {
            output.imaginary = 0.0;
            output.real = 0.0;
        }
        int m = x.getDataLength();
        int i = 0;
        while (i < m) {
            double realX = x.data[i];
            double imagX = x.data[i + 1];
            double realY = y.data[i];
            double imagY = y.data[i + 1];
            output.real += realX * realY - imagX * imagY;
            output.imaginary += realX * imagY + imagX * realY;
            i += 2;
        }
        return output;
    }

    public static Complex64F innerProdH(CDenseMatrix64F x, CDenseMatrix64F y, Complex64F output) {
        if (output == null) {
            output = new Complex64F();
        } else {
            output.imaginary = 0.0;
            output.real = 0.0;
        }
        int m = x.getDataLength();
        int i = 0;
        while (i < m) {
            double realX = x.data[i];
            double imagX = x.data[i + 1];
            double realY = y.data[i];
            double imagY = -y.data[i + 1];
            output.real += realX * realY - imagX * imagY;
            output.imaginary += realX * imagY + imagX * realY;
            i += 2;
        }
        return output;
    }

    public static void outerProd(CDenseMatrix64F x, CDenseMatrix64F y, CDenseMatrix64F A) {
        int m = A.numRows;
        int n = A.numCols;
        int index = 0;
        int i = 0;
        while (i < m) {
            double realX = x.data[i * 2];
            double imagX = x.data[i * 2 + 1];
            int indexY = 0;
            int j = 0;
            while (j < n) {
                double realY = y.data[indexY++];
                double imagY = y.data[indexY++];
                A.data[index++] = realX * realY - imagX * imagY;
                A.data[index++] = realX * imagY + imagX * realY;
                ++j;
            }
            ++i;
        }
    }

    public static void outerProdH(CDenseMatrix64F x, CDenseMatrix64F y, CDenseMatrix64F A) {
        int m = A.numRows;
        int n = A.numCols;
        int index = 0;
        int i = 0;
        while (i < m) {
            double realX = x.data[i * 2];
            double imagX = x.data[i * 2 + 1];
            int indexY = 0;
            int j = 0;
            while (j < n) {
                double realY = y.data[indexY++];
                double imagY = -y.data[indexY++];
                A.data[index++] = realX * realY - imagX * imagY;
                A.data[index++] = realX * imagY + imagX * realY;
                ++j;
            }
            ++i;
        }
    }
}

