/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackagerfat;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarPackagerMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class FatJarAntExporter {
    private static final String ANT_PROPERTYNAME_DIR_BUILDFILE = "dir.buildfile";
    private static final String ANT_PROPERTYNAME_DIR_WORKSPACE = "dir.workspace";
    private static final String ANT_PROPERTYNAME_DIR_JARFILE = "dir.jarfile";
    private static final String ANT_PROPERTY_DIR_BUILDFILE = "${dir.buildfile}";
    private static final String ANT_PROPERTY_DIR_WORKSPACE = "${dir.workspace}";
    private static final String ANT_PROPERTY_DIR_JARFILE = "${dir.jarfile}";
    private ILaunchConfiguration fLaunchConfiguration;
    private IPath fAbsJarfile;
    private IPath fAntScriptLocation;
    private String fBuildfileDir;
    private String fWorkspaceDir;
    private String fJarfileDir;
    private PathSubstituter pathSubstituter;

    public FatJarAntExporter(IPath antScriptLocation, IPath jarLocation, ILaunchConfiguration launchConfiguration) {
        this.fLaunchConfiguration = launchConfiguration;
        this.fAbsJarfile = jarLocation;
        this.fAntScriptLocation = antScriptLocation;
        this.pathSubstituter = new PathSubstituter();
        try {
            this.fBuildfileDir = antScriptLocation.toFile().getParentFile().getCanonicalPath();
            this.pathSubstituter.addSubstitution(this.fBuildfileDir, ANT_PROPERTY_DIR_BUILDFILE);
        }
        catch (Exception e) {
            JavaPlugin.log(e);
            this.fBuildfileDir = "?";
        }
        try {
            this.fJarfileDir = jarLocation.toFile().getParentFile().getCanonicalPath();
            this.pathSubstituter.addSubstitution(this.fJarfileDir, ANT_PROPERTY_DIR_JARFILE);
        }
        catch (Exception e) {
            JavaPlugin.log(e);
            this.fJarfileDir = "?";
        }
        try {
            this.fWorkspaceDir = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().getCanonicalPath();
            this.pathSubstituter.addSubstitution(this.fWorkspaceDir, ANT_PROPERTY_DIR_WORKSPACE);
        }
        catch (Exception e) {
            JavaPlugin.log(e);
            this.fWorkspaceDir = "?";
        }
    }

    public void run(MultiStatus status) throws CoreException {
        try {
            IPath[] classpath = FatJarAntExporter.getClasspath(this.fLaunchConfiguration);
            String mainClass = FatJarAntExporter.getMainClass(this.fLaunchConfiguration, status);
            String projectName = this.fLaunchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
            this.buildANTScript(this.fAntScriptLocation, projectName, this.fAbsJarfile, mainClass, FatJarAntExporter.convert(classpath));
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", Messages.format(FatJarPackagerMessages.FatJarPackageWizard_antScript_error_readingOutputFile, new Object[]{BasicElementLabels.getPathLabel(this.fAntScriptLocation, true), e.getLocalizedMessage()})));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", Messages.format(FatJarPackagerMessages.FatJarPackageWizard_antScript_error_writingOutputFile, new Object[]{BasicElementLabels.getPathLabel(this.fAntScriptLocation, true), e.getLocalizedMessage()})));
        }
    }

    private static IPath[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
        entries = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)configuration);
        ArrayList<IPath> userEntries = new ArrayList<IPath>(entries.length);
        int i = 0;
        while (i < entries.length) {
            IPath entry;
            String location;
            if (entries[i].getClasspathProperty() == 3 && (location = entries[i].getLocation()) != null && !userEntries.contains(entry = Path.fromOSString((String)location))) {
                userEntries.add(entry);
            }
            ++i;
        }
        return userEntries.toArray(new IPath[userEntries.size()]);
    }

    private static String getMainClass(ILaunchConfiguration launchConfig, MultiStatus status) {
        String result = null;
        if (launchConfig != null) {
            try {
                result = launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        if (result == null) {
            status.add((IStatus)new Status(2, "org.eclipse.jdt.ui", FatJarPackagerMessages.FatJarPackageWizardPage_LaunchConfigurationWithoutMainType_warning));
            result = "";
        }
        return result;
    }

    protected static SourceInfo[] convert(IPath[] classpath) {
        SourceInfo[] result = new SourceInfo[classpath.length];
        int i = 0;
        while (i < classpath.length) {
            IPath path = classpath[i];
            if (path != null) {
                if (path.toFile().isDirectory()) {
                    result[i] = new SourceInfo(false, path.toString(), "");
                } else if (path.toFile().isFile()) {
                    result[i] = new SourceInfo(true, path.toString(), "");
                }
            }
            ++i;
        }
        return result;
    }

    protected void addBaseDirProperties(Document document, Element project) {
        Comment comment = document.createComment("define folder properties");
        project.appendChild(comment);
        Element property = document.createElement("property");
        property.setAttribute("name", ANT_PROPERTYNAME_DIR_BUILDFILE);
        property.setAttribute("value", ".");
        project.appendChild(property);
        property = document.createElement("property");
        property.setAttribute("name", ANT_PROPERTYNAME_DIR_WORKSPACE);
        property.setAttribute("value", this.getWorkspaceRelativeDir());
        project.appendChild(property);
        property = document.createElement("property");
        property.setAttribute("name", ANT_PROPERTYNAME_DIR_JARFILE);
        property.setAttribute("value", this.getJarfileRelativeDir());
        project.appendChild(property);
    }

    protected String substituteBaseDirs(String absFilename) {
        String canonicleFilename;
        try {
            canonicleFilename = new File(absFilename).getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return absFilename;
        }
        String result = this.pathSubstituter.substitute(canonicleFilename);
        result = result.replace(File.separatorChar, '/');
        return result;
    }

    protected String getWorkspaceRelativeDir() {
        String result;
        if (this.fBuildfileDir.startsWith(String.valueOf(this.fWorkspaceDir) + File.separator)) {
            int lastSlash = this.fWorkspaceDir.length();
            result = ANT_PROPERTY_DIR_BUILDFILE + File.separator + "..";
            lastSlash = this.fBuildfileDir.indexOf(File.separator, lastSlash + 1);
            while (lastSlash != -1) {
                result = String.valueOf(result) + File.separator + "..";
                lastSlash = this.fBuildfileDir.indexOf(File.separator, lastSlash + 1);
            }
        } else {
            result = new PathSubstituter().addSubstitution(this.fBuildfileDir, ANT_PROPERTY_DIR_BUILDFILE).substitute(this.fWorkspaceDir);
        }
        result = result.replace(File.separatorChar, '/');
        return result;
    }

    protected String getJarfileRelativeDir() {
        String result = new PathSubstituter().addSubstitution(this.fBuildfileDir, ANT_PROPERTY_DIR_BUILDFILE).addSubstitution(this.fWorkspaceDir, ANT_PROPERTY_DIR_WORKSPACE).substitute(this.fJarfileDir);
        result = result.replace(File.separatorChar, '/');
        return result;
    }

    protected abstract void buildANTScript(IPath var1, String var2, IPath var3, String var4, SourceInfo[] var5) throws IOException;

    private static class PathSubstituter {
        private Map<String, String> pathSubstitutions = new HashMap<String, String>();

        private PathSubstituter() {
        }

        public PathSubstituter addSubstitution(String basePath, String baseReplacement) {
            this.pathSubstitutions.put(basePath, baseReplacement);
            return this;
        }

        public String substitute(String path) {
            int len = 0;
            String result = path;
            for (String basePath : this.pathSubstitutions.keySet()) {
                if (basePath.length() < len) continue;
                if (path.equals(basePath)) {
                    result = this.pathSubstitutions.get(basePath);
                    break;
                }
                if (!path.startsWith(String.valueOf(basePath) + File.separator)) continue;
                len = basePath.length();
                result = String.valueOf(this.pathSubstitutions.get(basePath)) + path.substring(len);
            }
            return result;
        }
    }

    protected static class SourceInfo {
        public final boolean isJar;
        public final String absPath;
        public final String relJarPath;

        public SourceInfo(boolean isJar, String absPath, String relJarPath) {
            this.isJar = isJar;
            this.absPath = absPath;
            this.relJarPath = relJarPath;
        }
    }
}

