/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import java.util.ArrayList;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodWrapper;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;

public class RefreshElementAction
extends Action {
    private final CallHierarchyViewer fViewer;

    public RefreshElementAction(CallHierarchyViewer viewer) {
        this.fViewer = viewer;
        this.setText(CallHierarchyMessages.RefreshSingleElementAction_text);
        this.setToolTipText(CallHierarchyMessages.RefreshSingleElementAction_tooltip);
        this.setDescription(CallHierarchyMessages.RefreshSingleElementAction_description);
        JavaPluginImages.setLocalImageDescriptors((IAction)this, "refresh.png");
        this.setActionDefinitionId("org.eclipse.ui.file.refresh");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.call_hierarchy_refresh_single_element_action_context");
        this.setEnabled(true);
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        if (selection.isEmpty()) {
            this.fViewer.getPart().refresh();
            return;
        }
        ArrayList<MethodWrapper> toExpand = new ArrayList<MethodWrapper>();
        for (MethodWrapper element : selection) {
            boolean isExpanded = this.fViewer.getExpandedState((Object)element);
            element.removeFromCache();
            if (isExpanded) {
                this.fViewer.setExpandedState((Object)element, false);
                toExpand.add(element);
            }
            this.fViewer.refresh((Object)element);
        }
        for (MethodWrapper elem : toExpand) {
            this.fViewer.setExpandedState((Object)elem, true);
        }
    }

    private ISelection getSelection() {
        return this.fViewer.getSelection();
    }
}

