/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.ui.views;

import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.ux.extension.ui.definitions.ChromatogramType;
import org.eclipse.chemclipse.ux.extension.ui.explorer.AbstractSelectionView;
import org.eclipse.chemclipse.ux.extension.ui.views.IChromatogramSelectionView;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public abstract class AbstractChromatogramSelectionView
extends AbstractSelectionView
implements IChromatogramSelectionView {
    private IChromatogramSelection chromatogramSelection;
    private IEventBroker eventBroker;
    private EventHandler eventHandler;

    public AbstractChromatogramSelectionView(MPart part, EPartService partService, IEventBroker eventBroker) {
        super(part, partService);
        this.eventBroker = eventBroker;
        this.subscribe();
    }

    @Override
    public IChromatogramSelection getChromatogramSelection() {
        if (this.chromatogramSelection == null) {
            this.chromatogramSelection = ChromatogramType.getChromatogramSelection();
        }
        return this.chromatogramSelection;
    }

    @Override
    public void setChromatogramSelection(IChromatogramSelection chromatogramSelection) {
        this.chromatogramSelection = chromatogramSelection;
    }

    private void subscribe() {
        if (this.eventBroker != null) {
            this.eventHandler = new EventHandler(){

                public void handleEvent(Event event) {
                    AbstractChromatogramSelectionView.this.chromatogramSelection = (IChromatogramSelection)event.getProperty("ChromatogramSelection");
                    boolean forceReload = (Boolean)event.getProperty("ForceReload");
                    AbstractChromatogramSelectionView.this.update(AbstractChromatogramSelectionView.this.chromatogramSelection, forceReload);
                }
            };
            this.eventBroker.subscribe("chromatogram/msd/update/chromatogramselection", this.eventHandler);
            this.eventBroker.subscribe("chromatogram/csd/update/chromatogramselection", this.eventHandler);
            this.eventBroker.subscribe("chromatogram/wsd/update/chromatogramselection", this.eventHandler);
        }
    }

    @Override
    public void unsubscribe() {
        if (this.eventBroker != null && this.eventHandler != null) {
            this.eventBroker.unsubscribe(this.eventHandler);
        }
    }
}

