/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.csd.ui.support;

import java.io.File;
import org.eclipse.chemclipse.csd.converter.chromatogram.ChromatogramConverterCSD;
import org.eclipse.chemclipse.model.core.IChromatogram;
import org.eclipse.chemclipse.model.core.IChromatogramOverview;
import org.eclipse.chemclipse.ux.extension.csd.ui.internal.support.ChromatogramIdentifier;
import org.eclipse.chemclipse.ux.extension.ui.provider.AbstractChromatogramEditorSupport;
import org.eclipse.chemclipse.ux.extension.ui.provider.IChromatogramEditorSupport;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class ChromatogramEditorSupport
extends AbstractChromatogramEditorSupport
implements IChromatogramEditorSupport {
    public ChromatogramEditorSupport() {
        super(ChromatogramConverterCSD.getChromatogramConverterSupport().getSupplier());
    }

    public String getType() {
        return "CSD";
    }

    public void openEditor(File file, EModelService modelService, MApplication application, EPartService partService) {
        if (ChromatogramIdentifier.isChromatogram(file) || ChromatogramIdentifier.isChromatogramDirectory(file)) {
            this.modelService = modelService;
            this.application = application;
            this.partService = partService;
            this.openEditor(file, null, "org.eclipse.chemclipse.ux.extension.csd.ui.part.chromatogramEditor", "bundleclass://org.eclipse.chemclipse.ux.extension.csd.ui/org.eclipse.chemclipse.ux.extension.csd.ui.editors.ChromatogramEditorCSD", "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/chromatogram.gif", "Chromatogram - Detector Type: CSD");
        }
    }

    public void openEditor(IChromatogram chromatogram, EModelService modelService, MApplication application, EPartService partService) {
        this.modelService = modelService;
        this.application = application;
        this.partService = partService;
        this.openEditor(null, chromatogram, "org.eclipse.chemclipse.ux.extension.csd.ui.part.chromatogramEditor", "bundleclass://org.eclipse.chemclipse.ux.extension.csd.ui/org.eclipse.chemclipse.ux.extension.csd.ui.editors.ChromatogramEditorCSD", "platform:/plugin/org.eclipse.chemclipse.rcp.ui.icons/icons/16x16/chromatogram.gif", "Chromatogram - Detector Type: CSD");
    }

    public void openOverview(File file, IEventBroker eventBroker) {
        if (ChromatogramIdentifier.isChromatogram(file) || ChromatogramIdentifier.isChromatogramDirectory(file)) {
            eventBroker.send("chromatogram/csd/update/rawfile", (Object)file);
        }
    }

    public void openOverview(IChromatogramOverview chromatogramOverview, IEventBroker eventBroker) {
        eventBroker.send("chromatogram/csd/update/overview", (Object)chromatogramOverview);
    }
}

