/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.runnables.dialogs;

import java.text.DecimalFormat;
import java.text.ParseException;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.database.controller.ConcentrationResponseEntryEdit;
import org.eclipse.chemclipse.chromatogram.msd.quantitation.supplier.chemclipse.ui.internal.runnables.dialogs.AbstractEntryEditDialog;
import org.eclipse.chemclipse.logging.core.Logger;
import org.eclipse.chemclipse.msd.model.core.quantitation.ConcentrationResponseEntryMSD;
import org.eclipse.chemclipse.msd.model.core.quantitation.IConcentrationResponseEntryMSD;
import org.eclipse.chemclipse.support.text.ValueFormat;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ConcentrationResponseEntryEditDialog
extends AbstractEntryEditDialog {
    private static final Logger logger = Logger.getLogger(ConcentrationResponseEntryEditDialog.class);
    private static final String KEY_ION = "Ion";
    private static final String KEY_CONCENTRATION = "Concentration";
    private static final String KEY_RESPONSE = "Response";
    private ConcentrationResponseEntryEdit concentrationResponseEntryEdit;
    private DecimalFormat decimalFormat;

    public ConcentrationResponseEntryEditDialog(Shell parentShell, ConcentrationResponseEntryEdit concentrationResponseEntryEdit, String title) {
        super(parentShell, title, "Create/Edit a concentration response entry.");
        this.concentrationResponseEntryEdit = concentrationResponseEntryEdit;
        this.decimalFormat = ValueFormat.getDecimalFormatEnglish();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            try {
                double ion = this.decimalFormat.parse(this.getWidgetInput(KEY_ION)).doubleValue();
                double concentration = this.decimalFormat.parse(this.getWidgetInput(KEY_CONCENTRATION)).doubleValue();
                double response = this.decimalFormat.parse(this.getWidgetInput(KEY_RESPONSE)).doubleValue();
                ConcentrationResponseEntryMSD concentrationResponseEntryMSD = new ConcentrationResponseEntryMSD(ion, concentration, response);
                this.concentrationResponseEntryEdit.setConcentrationResponseEntryMSD((IConcentrationResponseEntryMSD)concentrationResponseEntryMSD);
            }
            catch (ParseException e) {
                this.setErrorMessage("A value can't be parsed.");
                logger.warn((Object)e);
            }
        }
        super.buttonPressed(buttonId);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData layoutData = new GridData(1796);
        layoutData.widthHint = this.convertHorizontalDLUsToPixels(300);
        String ion = "";
        String concentration = "";
        String response = "";
        IConcentrationResponseEntryMSD concentrationResponseEntryMSD = this.concentrationResponseEntryEdit.getConcentrationResponseEntryMSD();
        if (concentrationResponseEntryMSD != null) {
            ion = this.decimalFormat.format(concentrationResponseEntryMSD.getIon());
            concentration = this.decimalFormat.format(concentrationResponseEntryMSD.getConcentration());
            response = this.decimalFormat.format(concentrationResponseEntryMSD.getResponse());
        }
        this.createTextInput(composite, layoutData, KEY_ION, "TIC = 0", ion, true);
        this.createTextInput(composite, layoutData, KEY_CONCENTRATION, this.concentrationResponseEntryEdit.getConcentrationUnit(), concentration, true);
        this.createTextInput(composite, layoutData, KEY_RESPONSE, "", response, true);
        this.validateInput();
        return composite;
    }

    @Override
    protected boolean validateInput() {
        boolean isValid = super.validateInput();
        if (isValid) {
            double value;
            try {
                value = this.decimalFormat.parse(this.getWidgetInput(KEY_ION)).doubleValue();
                if (value < 0.0) {
                    this.setErrorMessage("Select a ion >= 0 (TIC = 0).");
                    return false;
                }
            }
            catch (ParseException parseException) {
                this.setErrorMessage("The ion is not valid.");
                return false;
            }
            try {
                value = this.decimalFormat.parse(this.getWidgetInput(KEY_CONCENTRATION)).doubleValue();
                if (value <= 0.0) {
                    this.setErrorMessage("Select a concentration > 0.");
                    return false;
                }
            }
            catch (ParseException parseException) {
                this.setErrorMessage("The concentration is not valid.");
                return false;
            }
            try {
                value = this.decimalFormat.parse(this.getWidgetInput(KEY_RESPONSE)).doubleValue();
                if (value <= 0.0) {
                    this.setErrorMessage("Select a response > 0.");
                    return false;
                }
            }
            catch (ParseException parseException) {
                this.setErrorMessage("The response is not valid.");
                return false;
            }
        }
        return isValid;
    }
}

