/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonPositiveDefiniteMatrixException;
import org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.commons.math3.linear.NonSymmetricMatrixException;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.FastMath;

public class CholeskyDecomposition {
    public static final double DEFAULT_RELATIVE_SYMMETRY_THRESHOLD = 1.0E-15;
    public static final double DEFAULT_ABSOLUTE_POSITIVITY_THRESHOLD = 1.0E-10;
    private double[][] lTData;
    private RealMatrix cachedL;
    private RealMatrix cachedLT;

    public CholeskyDecomposition(RealMatrix matrix) {
        this(matrix, 1.0E-15, 1.0E-10);
    }

    public CholeskyDecomposition(RealMatrix matrix, double relativeSymmetryThreshold, double absolutePositivityThreshold) {
        if (!matrix.isSquare()) {
            throw new NonSquareMatrixException(matrix.getRowDimension(), matrix.getColumnDimension());
        }
        int order = matrix.getRowDimension();
        this.lTData = matrix.getData();
        this.cachedL = null;
        this.cachedLT = null;
        int i = 0;
        while (i < order) {
            double[] lI = this.lTData[i];
            int j = i + 1;
            while (j < order) {
                double[] lJ = this.lTData[j];
                double lIJ = lI[j];
                double lJI = lJ[i];
                double maxDelta = relativeSymmetryThreshold * FastMath.max(FastMath.abs(lIJ), FastMath.abs(lJI));
                if (FastMath.abs(lIJ - lJI) > maxDelta) {
                    throw new NonSymmetricMatrixException(i, j, relativeSymmetryThreshold);
                }
                lJ[i] = 0.0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < order) {
            double[] ltI = this.lTData[i];
            if (ltI[i] <= absolutePositivityThreshold) {
                throw new NonPositiveDefiniteMatrixException(ltI[i], i, absolutePositivityThreshold);
            }
            ltI[i] = FastMath.sqrt(ltI[i]);
            double inverse = 1.0 / ltI[i];
            int q = order - 1;
            while (q > i) {
                int n = q;
                ltI[n] = ltI[n] * inverse;
                double[] ltQ = this.lTData[q];
                int p = q;
                while (p < order) {
                    int n2 = p;
                    ltQ[n2] = ltQ[n2] - ltI[q] * ltI[p];
                    ++p;
                }
                --q;
            }
            ++i;
        }
    }

    public RealMatrix getL() {
        if (this.cachedL == null) {
            this.cachedL = this.getLT().transpose();
        }
        return this.cachedL;
    }

    public RealMatrix getLT() {
        if (this.cachedLT == null) {
            this.cachedLT = MatrixUtils.createRealMatrix(this.lTData);
        }
        return this.cachedLT;
    }

    public double getDeterminant() {
        double determinant = 1.0;
        int i = 0;
        while (i < this.lTData.length) {
            double lTii = this.lTData[i][i];
            determinant *= lTii * lTii;
            ++i;
        }
        return determinant;
    }

    public DecompositionSolver getSolver() {
        return new Solver(this.lTData);
    }

    private static class Solver
    implements DecompositionSolver {
        private final double[][] lTData;

        private Solver(double[][] lTData) {
            this.lTData = lTData;
        }

        @Override
        public boolean isNonSingular() {
            return true;
        }

        @Override
        public RealVector solve(RealVector b) {
            int m = this.lTData.length;
            if (b.getDimension() != m) {
                throw new DimensionMismatchException(b.getDimension(), m);
            }
            double[] x = b.toArray();
            int j = 0;
            while (j < m) {
                double[] lJ = this.lTData[j];
                int n = j;
                x[n] = x[n] / lJ[j];
                double xJ = x[j];
                int i = j + 1;
                while (i < m) {
                    int n2 = i;
                    x[n2] = x[n2] - xJ * lJ[i];
                    ++i;
                }
                ++j;
            }
            j = m - 1;
            while (j >= 0) {
                int n = j;
                x[n] = x[n] / this.lTData[j][j];
                double xJ = x[j];
                int i = 0;
                while (i < j) {
                    int n3 = i;
                    x[n3] = x[n3] - xJ * this.lTData[i][j];
                    ++i;
                }
                --j;
            }
            return new ArrayRealVector(x, false);
        }

        @Override
        public RealMatrix solve(RealMatrix b) {
            int m = this.lTData.length;
            if (b.getRowDimension() != m) {
                throw new DimensionMismatchException(b.getRowDimension(), m);
            }
            int nColB = b.getColumnDimension();
            double[][] x = b.getData();
            int j = 0;
            while (j < m) {
                double[] lJ = this.lTData[j];
                double lJJ = lJ[j];
                double[] xJ = x[j];
                int k = 0;
                while (k < nColB) {
                    int n = k++;
                    xJ[n] = xJ[n] / lJJ;
                }
                int i = j + 1;
                while (i < m) {
                    double[] xI = x[i];
                    double lJI = lJ[i];
                    int k2 = 0;
                    while (k2 < nColB) {
                        int n = k2;
                        xI[n] = xI[n] - xJ[k2] * lJI;
                        ++k2;
                    }
                    ++i;
                }
                ++j;
            }
            j = m - 1;
            while (j >= 0) {
                double lJJ = this.lTData[j][j];
                double[] xJ = x[j];
                int k = 0;
                while (k < nColB) {
                    int n = k++;
                    xJ[n] = xJ[n] / lJJ;
                }
                int i = 0;
                while (i < j) {
                    double[] xI = x[i];
                    double lIJ = this.lTData[i][j];
                    int k3 = 0;
                    while (k3 < nColB) {
                        int n = k3;
                        xI[n] = xI[n] - xJ[k3] * lIJ;
                        ++k3;
                    }
                    ++i;
                }
                --j;
            }
            return new Array2DRowRealMatrix(x);
        }

        @Override
        public RealMatrix getInverse() {
            return this.solve(MatrixUtils.createRealIdentityMatrix(this.lTData.length));
        }
    }
}

