/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.CFOperation;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;

public abstract class ModulesOperation
extends CFOperation {
    private final IModule[] modules;

    public ModulesOperation(CloudFoundryServerBehaviour behaviour, IModule[] modules) {
        super(behaviour);
        this.modules = modules;
    }

    public ModulesOperation(CloudFoundryServerBehaviour behaviour, IModule module) {
        super(behaviour);
        this.modules = new IModule[]{module};
    }

    protected abstract void runOnVerifiedModule(IProgressMonitor var1) throws CoreException;

    @Override
    public final void run(IProgressMonitor monitor) throws CoreException {
        this.run(monitor, -1);
    }

    public final void run(IProgressMonitor monitor, int monitorParentWorkedSize) throws CoreException {
        CloudFoundryApplicationModule appModule;
        if (monitorParentWorkedSize > -1) {
            monitor = ModulesOperation.convertAndConsumeParentSubProgressMonitor(monitor, monitorParentWorkedSize);
        }
        if (this.getFirstModule() == null) {
            throw CloudErrorUtil.toCoreException(NLS.bind((String)Messages.ModulesOperation_NO_MODULE, (Object)this.getOperationName()));
        }
        if (this.clearFirstModuleStatus() && (appModule = this.getCloudModule(this.getFirstModule())) != null) {
            appModule.setStatus(null);
        }
        try {
            this.runOnVerifiedModule(monitor);
        }
        catch (CoreException e) {
            CloudFoundryApplicationModule appModule2 = this.getCloudModule(this.getFirstModule());
            if (appModule2 != null) {
                appModule2.setAndLogErrorStatus(e, this.getOperationName());
            } else {
                this.logNonModuleError(e);
            }
            throw e;
        }
    }

    protected boolean clearFirstModuleStatus() {
        return true;
    }

    protected IModule[] getModules() {
        return this.modules;
    }

    public IModule getFirstModule() {
        return this.modules[0];
    }

    private static IProgressMonitor convertAndConsumeParentSubProgressMonitor(IProgressMonitor monitor, int parentWorkedSize) {
        return new SubProgressMonitor(monitor, parentWorkedSize);
    }
}

