/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cft.server.core.ArchiveEntry;
import org.eclipse.cft.server.core.CFApplicationArchive;
import org.eclipse.cft.server.core.internal.application.AbstractArchiveEntry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;

public abstract class AbstractModuleResourceArchive
implements CFApplicationArchive {
    protected List<ArchiveEntry> entries;
    private final IModule module;
    private final List<IModuleResource> resources;

    protected AbstractModuleResourceArchive(IModule module, List<IModuleResource> resources) {
        this.module = module;
        this.resources = resources;
    }

    @Override
    public Iterable<ArchiveEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<ArchiveEntry>();
            this.collectEntriesPriorToDeployment(this.entries, this.resources.toArray(new IModuleResource[0]));
        }
        return this.entries;
    }

    protected List<IModuleResource> getModuleResources() {
        return this.resources;
    }

    protected void collectEntriesPriorToDeployment(List<ArchiveEntry> entries, IModuleResource[] members) {
        if (members == null) {
            return;
        }
        IModuleResource[] iModuleResourceArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleFolder folder;
            ModuleFolderEntryAdapter folderAdapter;
            IModuleResource resource = iModuleResourceArray[n2];
            if (resource instanceof IModuleFile) {
                ModuleFileEntryAdapter fileAdapter = this.getFileResourceEntryAdapter((IModuleFile)resource);
                if (fileAdapter != null) {
                    entries.add(fileAdapter);
                }
            } else if (resource instanceof IModuleFolder && (folderAdapter = this.getModuleFolderAdapter(folder = (IModuleFolder)resource)) != null) {
                entries.add(folderAdapter);
                this.collectEntriesPriorToDeployment(entries, folder.members());
            }
            ++n2;
        }
    }

    protected abstract ModuleFolderEntryAdapter getModuleFolderAdapter(IModuleFolder var1);

    protected abstract ModuleFileEntryAdapter getFileResourceEntryAdapter(IModuleFile var1);

    protected IModule getModule() {
        return this.module;
    }

    public abstract class AbstractModuleResourceEntryAdapter
    extends AbstractArchiveEntry {
        private final IModuleResource moduleResource;
        protected String name;

        public AbstractModuleResourceEntryAdapter(IModuleResource moduleResource) {
            this.moduleResource = moduleResource;
            this.name = this.computeName(moduleResource);
        }

        public IModuleResource getResource() {
            return this.moduleResource;
        }

        @Override
        public String getName() {
            return this.name;
        }

        protected abstract String computeName(IModuleResource var1);
    }

    public abstract class ModuleFileEntryAdapter
    extends AbstractModuleResourceEntryAdapter {
        protected final File file;

        public ModuleFileEntryAdapter(IModuleFile moduleResource) {
            super((IModuleResource)moduleResource);
            this.file = this.getFile((IModuleResource)moduleResource);
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        protected File getFile(IModuleResource moduleResource) {
            IPath location;
            IFile iFile;
            File file = (File)moduleResource.getAdapter(File.class);
            if (file == null && (iFile = (IFile)moduleResource.getAdapter(IFile.class)) != null && (location = iFile.getLocation()) != null) {
                return new File(location.toString());
            }
            return file;
        }

        protected boolean canComputeResourceEntry() {
            return this.file != null && this.file.exists();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.canComputeResourceEntry()) {
                return new FileInputStream(this.file);
            }
            return null;
        }
    }

    public abstract class ModuleFolderEntryAdapter
    extends AbstractModuleResourceEntryAdapter {
        public ModuleFolderEntryAdapter(IModuleFolder moduleResource) {
            super((IModuleResource)moduleResource);
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public long getSize() {
            return -1L;
        }

        @Override
        public byte[] getSha1Digest() {
            return null;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return null;
        }
    }
}

