/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.eclipse.cft.server.core.CFServiceInstance;
import org.eclipse.cft.server.core.EnvironmentVariable;

public class ApplicationDeploymentInfo
extends Observable {
    private List<String> uris;
    private HashMap<Object, Object> deploymentInfoMap = new HashMap();

    public ApplicationDeploymentInfo(String appName) {
        this.setDeploymentName(appName);
    }

    public void setEnvVariables(List<EnvironmentVariable> envVars) {
        List<EnvironmentVariable> curEnvVars = this.getEnvVariables();
        if (curEnvVars == envVars) {
            this.setChanged();
            this.notifyObservers(envVars);
        } else {
            curEnvVars.clear();
            if (envVars != null) {
                curEnvVars.addAll(envVars);
                this.setChanged();
                this.notifyObservers(envVars);
            }
        }
    }

    public List<EnvironmentVariable> getEnvVariables() {
        ArrayList curEnvVars = this.deploymentInfoMap.get("env");
        if (curEnvVars == null) {
            curEnvVars = new ArrayList();
            this.deploymentInfoMap.put("env", curEnvVars);
        }
        return curEnvVars;
    }

    public int getInstances() {
        return this.getIntValue("instances");
    }

    public void setInstances(int instances) {
        this.deploymentInfoMap.put("instances", instances);
    }

    public String getBuildpack() {
        return (String)this.deploymentInfoMap.get("buildpack");
    }

    public void setBuildpack(String buildpack) {
        this.setStringValue("buildpack", buildpack);
    }

    public String getDeploymentName() {
        return (String)this.deploymentInfoMap.get("name");
    }

    public String getCommand() {
        return (String)this.deploymentInfoMap.get("command");
    }

    public void setDeploymentName(String name) {
        this.setStringValue("name", name);
        this.setChanged();
        this.notifyObservers(name);
    }

    public void setUris(List<String> uris) {
        this.uris = uris;
    }

    public List<String> getUris() {
        return this.uris;
    }

    public List<CFServiceInstance> getServices() {
        return (List)this.deploymentInfoMap.get("services");
    }

    public List<String> asServiceBindingList() {
        ArrayList<String> bindingList = new ArrayList<String>();
        List<CFServiceInstance> services = this.getServices();
        if (services != null && !services.isEmpty()) {
            for (CFServiceInstance service : services) {
                bindingList.add(service.getName());
            }
        }
        return bindingList;
    }

    public void setServices(List<CFServiceInstance> services) {
        if (services == null) {
            this.deploymentInfoMap.remove("services");
        } else {
            this.deploymentInfoMap.put("services", services);
        }
    }

    public int getMemory() {
        return this.getIntValue("memory");
    }

    public void setMemory(int memory) {
        this.deploymentInfoMap.put("memory", memory);
    }

    public String getArchive() {
        return (String)this.deploymentInfoMap.get("path");
    }

    public void setArchive(String archive) {
        this.setStringValue("path", archive);
    }

    public Integer getDiskQuota() {
        return (Integer)this.deploymentInfoMap.get("disk_quota");
    }

    public void setDiskQuota(int diskQuota) {
        this.deploymentInfoMap.put("disk_quota", diskQuota);
    }

    private int getIntValue(String key) {
        Integer curInt = (Integer)this.deploymentInfoMap.get(key);
        return curInt != null ? curInt : 0;
    }

    public String getStack() {
        return (String)this.deploymentInfoMap.get("stack");
    }

    public void setStack(String curStack) {
        if (curStack == null) {
            this.deploymentInfoMap.remove("stack");
        } else {
            this.deploymentInfoMap.put("stack", curStack);
        }
    }

    public Integer getTimeout() {
        return (Integer)this.deploymentInfoMap.get("timeout");
    }

    public void setInfo(ApplicationDeploymentInfo info) {
        if (info == null) {
            return;
        }
        this.deploymentInfoMap = (HashMap)info.deploymentInfoMap.clone();
        if (info.getServices() != null) {
            this.setServices(new ArrayList<CFServiceInstance>(info.getServices()));
        } else {
            this.setServices(null);
        }
        if (info.getUris() != null) {
            this.setUris(new ArrayList<String>(info.getUris()));
        } else {
            this.setUris(null);
        }
        if (info.getEnvVariables() != null) {
            this.setEnvVariables(new ArrayList<EnvironmentVariable>(info.getEnvVariables()));
        } else {
            this.setEnvVariables(null);
        }
    }

    private void setStringValue(String keyStr, String valueStr) {
        if (valueStr == null) {
            this.deploymentInfoMap.remove(keyStr);
        } else {
            this.deploymentInfoMap.put(keyStr, valueStr);
        }
    }

    public ApplicationDeploymentInfo copy() {
        ApplicationDeploymentInfo info = new ApplicationDeploymentInfo(this.getDeploymentName());
        info.deploymentInfoMap = (HashMap)this.deploymentInfoMap.clone();
        if (this.getServices() != null) {
            info.setServices(new ArrayList<CFServiceInstance>(this.getServices()));
        }
        if (this.getUris() != null) {
            info.setUris(new ArrayList<String>(this.getUris()));
        }
        if (this.getEnvVariables() != null) {
            ArrayList<EnvironmentVariable> curEnvVaris = new ArrayList<EnvironmentVariable>();
            curEnvVaris.addAll(this.getEnvVariables());
            info.setEnvVariables(curEnvVaris);
        }
        return info;
    }

    public HashMap<Object, Object> getUnknownInfo() {
        HashMap curDeploymentInfoMap = (HashMap)this.deploymentInfoMap.clone();
        curDeploymentInfoMap.remove("applications");
        curDeploymentInfoMap.remove("buildpack");
        curDeploymentInfoMap.remove("disk_quota");
        curDeploymentInfoMap.remove("domain");
        curDeploymentInfoMap.remove("env");
        curDeploymentInfoMap.remove("instances");
        curDeploymentInfoMap.remove("memory");
        curDeploymentInfoMap.remove("name");
        curDeploymentInfoMap.remove("path");
        curDeploymentInfoMap.remove("services");
        curDeploymentInfoMap.remove("host");
        return curDeploymentInfoMap;
    }

    public void addAllToDeploymentMap(Map<?, ?> curDeploymentInfoMap) {
        this.deploymentInfoMap.putAll(curDeploymentInfoMap);
    }
}

