/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.IPersistenceAdapter;
import org.eclipse.capra.core.adapters.ITraceabilityInformationModelAdapter;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.ui.helpers.SelectionSupportHelper;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ViewPart;

public class SelectionView
extends ViewPart {
    public static final String ID = "org.eclipse.capra.ui.views.SelectionView";
    private static final String TRANSFER_EXTENSION_POINT_ID = "org.eclipse.capra.ui.transfers";
    private static final Transfer[] DEFAULT_TRANSFERS = new Transfer[]{ResourceTransfer.getInstance(), EditorInputTransfer.getInstance(), FileTransfer.getInstance(), RTFTransfer.getInstance(), TextTransfer.getInstance(), URLTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), LocalTransfer.getInstance()};
    private CheckboxTableViewer artifactTable;
    private ComboViewer traceTypeCombo;
    private HashMap<Object, Boolean> selection = new LinkedHashMap<Object, Boolean>();
    private IUndoContext undoContext = IOperationHistory.GLOBAL_UNDO_CONTEXT;
    private Collection<EClass> traceTypes = new ArrayList<EClass>();

    public void createPartControl(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new GridLayout(1, false));
        area.setLayoutData((Object)new GridData(4, 4, true, true));
        this.traceTypeCombo = new ComboViewer(area);
        this.traceTypeCombo.setContentProvider((IContentProvider)new TraceTypeContentProvider());
        this.traceTypeCombo.setLabelProvider((IBaseLabelProvider)new TraceTypeLabelProvider());
        this.traceTypeCombo.setInput((Object)this.getViewSite());
        this.traceTypeCombo.getCombo().setLayoutData((Object)new GridData(4, 128, true, false));
        this.artifactTable = CheckboxTableViewer.newCheckList((Composite)area, (int)2850);
        this.artifactTable.setContentProvider((IContentProvider)new ArtifactTableContentProvider());
        this.artifactTable.setLabelProvider((IBaseLabelProvider)new ArtifactTableLabelProvider());
        this.artifactTable.setComparator((ViewerComparator)new NoChangeComparator());
        this.artifactTable.addCheckStateListener((ICheckStateListener)new ArtifactTableStateChangeListenser());
        this.artifactTable.setCheckStateProvider((ICheckStateProvider)new ArtifactTableCheckStateProvider());
        this.artifactTable.setInput((Object)this.getViewSite());
        this.artifactTable.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.getSite().setSelectionProvider((ISelectionProvider)this.artifactTable);
        this.hookContextMenu();
        int ops = 3;
        ArrayList<Transfer> transfers = new ArrayList<Transfer>(Arrays.asList(DEFAULT_TRANSFERS));
        transfers.addAll(ExtensionPointHelper.getExtensions((String)TRANSFER_EXTENSION_POINT_ID, (String)"class").stream().map(Transfer.class::cast).collect(Collectors.toList()));
        this.artifactTable.addDropSupport(ops, transfers.toArray(DEFAULT_TRANSFERS), (DropTargetListener)new SelectionDropAdapter((TableViewer)this.artifactTable));
        this.createGlobalActionHandlers();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
            }
        });
        Menu menu = menuMgr.createContextMenu(this.artifactTable.getControl());
        this.artifactTable.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.artifactTable);
    }

    public void setFocus() {
        this.artifactTable.getControl().setFocus();
    }

    public void dropToSelection(Object data) {
        boolean selectAsSource = this.selection.isEmpty();
        if (data instanceof ISelection) {
            List<Object> extractedData = SelectionSupportHelper.extractSelectedElements((ISelection)data, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart());
            if (extractedData != null && extractedData.stream().allMatch(this::validateSelection)) {
                extractedData.forEach(e -> {
                    Boolean bl2 = this.selection.put(e, selectAsSource);
                });
            }
        } else if (data instanceof Collection) {
            Collection arrayselection = (Collection)data;
            if (arrayselection.stream().allMatch(this::validateSelection)) {
                arrayselection.forEach(a -> {
                    Boolean bl2 = this.selection.put(a, selectAsSource);
                });
            }
        } else if (this.validateSelection(data)) {
            this.selection.put(data, selectAsSource);
        }
        this.artifactTable.refresh();
        this.refreshAvailableTraceTypes();
    }

    private void refreshAvailableTraceTypes() {
        ITraceabilityInformationModelAdapter traceAdapter = (ITraceabilityInformationModelAdapter)ExtensionPointHelper.getTraceabilityInformationModelAdapter().orElseThrow();
        IPersistenceAdapter persistenceAdapter = (IPersistenceAdapter)ExtensionPointHelper.getPersistenceAdapter().orElseThrow();
        ResourceSet resourceSet = EditingDomainHelper.getResourceSet();
        EObject artifactModel = persistenceAdapter.getArtifactWrappers(resourceSet);
        ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
        List wrappers = artifactHelper.createWrappers(new ArrayList<Object>(this.selection.keySet()));
        this.traceTypes = traceAdapter.getAvailableTraceTypes(wrappers);
        this.traceTypeCombo.refresh();
    }

    private boolean validateSelection(Object target) {
        Collection artifactHandlers = ExtensionPointHelper.getArtifactHandlers();
        List availableHandlers = artifactHandlers.stream().filter(handler -> handler.canHandleArtifact(target)).collect(Collectors.toList());
        Optional priorityHandler = ExtensionPointHelper.getPriorityHandler();
        if (availableHandlers.isEmpty()) {
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)"No handler for selected item", (String)("There is no handler for " + target + " so it will be ignored."));
        } else if (availableHandlers.size() > 1 && !priorityHandler.isPresent()) {
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)"Multiple handlers for selected item", (String)("There are multiple handlers for " + target + " so it will be ignored."));
        } else {
            if (availableHandlers.size() > 1 && priorityHandler.isPresent()) {
                return true;
            }
            return true;
        }
        return false;
    }

    public List<Object> getSelection() {
        return new ArrayList<Object>(this.selection.keySet());
    }

    public List<Object> getSources() {
        return new ArrayList<Object>(this.selection.entrySet().stream().filter(entry -> Boolean.TRUE.equals(entry.getValue())).map(entry -> entry.getKey()).collect(Collectors.toList()));
    }

    public List<Object> getTargets() {
        return new ArrayList<Object>(this.selection.entrySet().stream().filter(entry -> Boolean.FALSE.equals(entry.getValue())).map(entry -> entry.getKey()).collect(Collectors.toList()));
    }

    public void clearSelection() {
        this.selection.clear();
        this.artifactTable.refresh();
        this.refreshAvailableTraceTypes();
    }

    public static SelectionView getOpenedView() {
        try {
            return (SelectionView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(ID);
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void removeFromSelection(List<Object> currentselection) {
        currentselection.forEach(this.selection::remove);
        this.artifactTable.refresh();
        this.refreshAvailableTraceTypes();
    }

    public EClass getSelectedTraceType() {
        EClass selectedTraceType = (EClass)this.traceTypeCombo.getStructuredSelection().getFirstElement();
        if (selectedTraceType == null && this.traceTypeCombo.getCombo().getItemCount() == 1) {
            selectedTraceType = (EClass)this.traceTypeCombo.getElementAt(0);
        }
        return selectedTraceType;
    }

    private void createGlobalActionHandlers() {
        UndoActionHandler undoAction = new UndoActionHandler(this.getSite(), this.undoContext);
        RedoActionHandler redoAction = new RedoActionHandler(this.getSite(), this.undoContext);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)redoAction);
        actionBars.updateActionBars();
    }

    class ArtifactTableCheckStateProvider
    implements ICheckStateProvider {
        ArtifactTableCheckStateProvider() {
        }

        public boolean isChecked(Object element) {
            return SelectionView.this.selection.get(element);
        }

        public boolean isGrayed(Object element) {
            return false;
        }
    }

    class ArtifactTableContentProvider
    implements IStructuredContentProvider {
        ArtifactTableContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object parent) {
            return SelectionView.this.selection.keySet().toArray();
        }
    }

    class ArtifactTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ArtifactTableLabelProvider() {
        }

        public String getText(Object element) {
            IPersistenceAdapter persistenceAdapter = (IPersistenceAdapter)ExtensionPointHelper.getPersistenceAdapter().orElseThrow();
            EObject artifactModel = persistenceAdapter.getArtifactWrappers(EditingDomainHelper.getResourceSet());
            ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
            IArtifactHandler handler = (IArtifactHandler)artifactHelper.getHandler(element).orElseThrow();
            return handler.withCastedHandler(element, (h, o) -> h.getDisplayName(o)).orElseGet(element::toString);
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }

    class ArtifactTableStateChangeListenser
    implements ICheckStateListener {
        ArtifactTableStateChangeListenser() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            SelectionView.this.selection.put(event.getElement(), event.getChecked());
        }
    }

    class NoChangeComparator
    extends ViewerComparator {
        NoChangeComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return 0;
        }
    }

    class SelectionDropAdapter
    extends ViewerDropAdapter {
        TableViewer view;

        public SelectionDropAdapter(TableViewer view) {
            super((Viewer)SelectionView.this.artifactTable);
            this.view = view;
        }

        public boolean performDrop(Object data) {
            SelectionView.this.dropToSelection(data);
            return true;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            return true;
        }
    }

    class TraceTypeContentProvider
    implements IStructuredContentProvider {
        TraceTypeContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return SelectionView.this.traceTypes.toArray();
        }
    }

    class TraceTypeLabelProvider
    extends LabelProvider
    implements IBaseLabelProvider {
        TraceTypeLabelProvider() {
        }

        public String getText(Object element) {
            return !(element instanceof EClass) ? "" : ((EClass)element).getName();
        }
    }
}

