/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.util.Comparator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public class SortedTreeNode
extends DefaultMutableTreeNode {
    private final Comparator<DefaultMutableTreeNode> comparator;

    public SortedTreeNode(Comparator<DefaultMutableTreeNode> comparator) {
        this.comparator = comparator;
    }

    public SortedTreeNode(Object userObject, Comparator<DefaultMutableTreeNode> comparator) {
        super(userObject);
        this.comparator = comparator;
    }

    public SortedTreeNode(Object userObject, boolean allowsChildren, Comparator<DefaultMutableTreeNode> comparator) {
        super(userObject, allowsChildren);
        this.comparator = comparator;
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        int insertIndex = 0;
        if (this.children == null || this.children.size() == 0) {
            super.insert(newChild, insertIndex);
            return;
        }
        int minIndex = 0;
        int maxIndex = this.children.size();
        boolean found = false;
        while (!found) {
            insertIndex = minIndex + (maxIndex - minIndex) / 2;
            int compareResult = this.comparator.compare((DefaultMutableTreeNode)newChild, (DefaultMutableTreeNode)this.children.get(insertIndex));
            if (compareResult == 0) {
                found = true;
            } else if (compareResult < 0) {
                if (insertIndex == maxIndex) {
                    found = true;
                    insertIndex = minIndex;
                } else {
                    maxIndex = insertIndex;
                }
            } else {
                if (insertIndex == minIndex) {
                    found = true;
                    insertIndex = maxIndex;
                }
                minIndex = insertIndex;
            }
            if (maxIndex != minIndex) continue;
            insertIndex = minIndex;
            found = true;
        }
        super.insert(newChild, insertIndex);
    }
}

