/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.docgen.preference.CapellaDocgenPreferenceHelper;
import org.polarsys.capella.docgen.util.CapellaPropertyServices;
import org.polarsys.capella.docgen.util.CapellaServices;

public class CapellaAssociationService {
    CapellaAssociationService() {
    }

    public static List<String> getInformationForAssociationNavigableMembers(Association association, String projectName, String outputFolder) {
        EList navigableMembers = association.getNavigableMembers();
        return CapellaAssociationService.getProperties((EList<Property>)navigableMembers, projectName, outputFolder);
    }

    public static List<String> getInformationForAssociationOwnedMembers(Association association, String projectName, String outputFolder) {
        EList ownedMembers = association.getOwnedMembers();
        return CapellaAssociationService.getProperties((EList<Property>)ownedMembers, projectName, outputFolder);
    }

    public static String getInformationFromAssociation(Association association, String projectName, String outputFolder) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(CapellaServices.getImageLinkFromElement((EObject)association, projectName, outputFolder));
        buffer.append(" ");
        if (CapellaDocgenPreferenceHelper.isExportAssociation()) {
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)association, association.getLabel()));
        } else {
            buffer.append(association.getLabel());
        }
        return buffer.toString();
    }

    private static List<String> getProperties(EList<Property> navigableMembers, String projectName, String outputFolder) {
        ArrayList<String> result = new ArrayList<String>();
        for (Property property : navigableMembers) {
            result.add(CapellaPropertyServices.getInformationFromProperty(property, projectName, outputFolder));
        }
        return result;
    }
}

