/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.helper;

import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.docgen.Activator;
import org.polarsys.capella.docgen.Messages;

public class CapellaVersionHelper {
    private static String DOT = ".";

    CapellaVersionHelper() {
    }

    public static boolean isSupportedCapellaVersion() {
        Version capellaPerspectiveBundleVersion;
        Boolean result = false;
        Bundle capellaPerspectiveBundle = FrameworkUtil.getBundle(CapellaElementExt.class);
        Version docgenBundleVersion = CapellaVersionHelper.getDocgenBundleVersion();
        if (capellaPerspectiveBundle != null && docgenBundleVersion != null && (capellaPerspectiveBundleVersion = capellaPerspectiveBundle.getVersion()).getMajor() == docgenBundleVersion.getMajor()) {
            result = true;
        }
        return result;
    }

    public static Version getDocgenBundleVersion() {
        Bundle docgenBundle = FrameworkUtil.getBundle(Activator.class);
        if (docgenBundle != null) {
            return docgenBundle.getVersion();
        }
        return null;
    }

    public static String getDocgenBundleVersionWithoutQualifier() {
        Version docgenBundleVersion = CapellaVersionHelper.getDocgenBundleVersion();
        if (docgenBundleVersion != null) {
            return String.valueOf(docgenBundleVersion.getMajor()) + DOT + "x";
        }
        return Messages.docgenVersionNotFound;
    }
}

