/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.trace;

import org.eclipse.egf.core.trace.Category;
import org.eclipse.egf.core.trace.Configuration;
import org.eclipse.egf.core.trace.Filter;
import org.eclipse.egf.core.trace.TraceFactory;
import org.eclipse.egf.pattern.trace.TraceHelper;
import org.eclipse.egf.pattern.trace.TraceState;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.trace.StringEditingSupport;
import org.eclipse.egf.pattern.ui.trace.TraceCategoryLabelProvider;
import org.eclipse.egf.pattern.ui.trace.TraceContentProvider;
import org.eclipse.egf.pattern.ui.trace.TraceFilterLabelProvider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TracePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer filterViewer;
    private CheckboxTableViewer categoryViewer;
    private Button addFilterButton;
    private Button delFilterButton;
    private Button upFilterButton;
    private Button downFilterButton;
    private Button addCategoryButton;
    private Button duplicateCategoryButton;
    private Button delCategoryButton;
    private Button upCategoryButton;
    private Button downCategoryButton;
    private boolean enableSubControl = false;
    private Configuration configuration;
    private Button noneBtn;
    private Button belowBtn;
    private Button alwaysBtn;

    public TracePreferencePage() {
        this.setTitle(Messages.TracePreferencePage_Title);
        this.setDescription(Messages.TracePreferencePage_Description);
    }

    protected void performDefaults() {
        this.configuration = TraceHelper.PREFERENCES.getDefaultConfiguration();
        this.categoryViewer.setInput((Object)this.configuration);
        this.filterViewer.setInput(null);
        this.alwaysBtn.setSelection(false);
        this.belowBtn.setSelection(false);
        this.noneBtn.setSelection(true);
        this.enableSubControl = false;
        this.setButtonStates();
        super.performDefaults();
    }

    public boolean performOk() {
        boolean performOk = super.performOk();
        if (performOk) {
            try {
                TraceState state = null;
                state = this.belowBtn.getSelection() ? TraceState.FILTERS : (this.alwaysBtn.getSelection() ? TraceState.ALWAYS : TraceState.NEVER);
                TraceHelper.PREFERENCES.save(state, this.configuration);
            }
            catch (Exception e) {
                Activator.getDefault().logError(e);
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.TracePreferencePage_Save_Error_Title, (String)Messages.TracePreferencePage_Save_Error_Message);
                return false;
            }
        }
        return performOk;
    }

    public void init(IWorkbench workbench_p) {
    }

    protected void createFilterControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.TracePreferencePage_Label_5);
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 2;
        label.setLayoutData((Object)layoutData);
        this.filterViewer = new TableViewer(parent, 68356);
        Table table = this.filterViewer.getTable();
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        layoutData = new GridData(1808);
        layoutData.minimumHeight = 200;
        table.setLayoutData((Object)layoutData);
        TableViewerColumn commentColumn = new TableViewerColumn(this.filterViewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 100, true));
        commentColumn.getColumn().setText(Messages.TracePreferencePage_Label_1);
        commentColumn.getColumn().setToolTipText(Messages.TracePreferencePage_Label_1_tooltip);
        commentColumn.getColumn().setResizable(true);
        commentColumn.getColumn().setData((Object)0);
        commentColumn.setEditingSupport((EditingSupport)new StringEditingSupport(this.filterViewer, Filter.class, "comment"));
        TableViewerColumn patternColumn = new TableViewerColumn(this.filterViewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 100, true));
        patternColumn.getColumn().setText(Messages.TracePreferencePage_Label_2);
        patternColumn.getColumn().setToolTipText(Messages.TracePreferencePage_Label_2_tooltip);
        patternColumn.getColumn().setResizable(true);
        patternColumn.getColumn().setData((Object)0);
        patternColumn.setEditingSupport((EditingSupport)new StringEditingSupport(this.filterViewer, Filter.class, "pattern"));
        this.filterViewer.setLabelProvider((IBaseLabelProvider)new TraceFilterLabelProvider());
        this.filterViewer.setContentProvider((IContentProvider)new TraceContentProvider());
        this.filterViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                TracePreferencePage.this.setButtonStates();
            }
        });
    }

    protected void createCategoryControl(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.TracePreferencePage_Label_6);
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 2;
        label.setLayoutData((Object)layoutData);
        this.categoryViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)68356);
        Table table = this.categoryViewer.getTable();
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        layoutData = new GridData(1808);
        layoutData.minimumHeight = 200;
        table.setLayoutData((Object)layoutData);
        TableViewerColumn idColumn = new TableViewerColumn((TableViewer)this.categoryViewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 100, true));
        idColumn.getColumn().setText(Messages.TracePreferencePage_Label_3);
        idColumn.getColumn().setResizable(true);
        idColumn.getColumn().setData((Object)0);
        TableViewerColumn nameColumn = new TableViewerColumn((TableViewer)this.categoryViewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(3, 100, true));
        nameColumn.getColumn().setText(Messages.TracePreferencePage_Label_4);
        nameColumn.getColumn().setToolTipText(Messages.TracePreferencePage_Label_4_tooltip);
        nameColumn.getColumn().setResizable(true);
        nameColumn.getColumn().setData((Object)0);
        nameColumn.setEditingSupport((EditingSupport)new StringEditingSupport((TableViewer)this.categoryViewer, Category.class, "name"));
        this.categoryViewer.setLabelProvider((IBaseLabelProvider)new TraceCategoryLabelProvider());
        this.categoryViewer.setContentProvider((IContentProvider)new TraceContentProvider());
        this.categoryViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isChecked(Object element) {
                if (element instanceof Category) {
                    return ((Category)element).isActive();
                }
                return false;
            }

            public boolean isGrayed(Object element) {
                return false;
            }
        });
        this.categoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                TracePreferencePage.this.filterViewer.setInput(((IStructuredSelection)selection).getFirstElement());
                TracePreferencePage.this.setButtonStates();
            }
        });
        this.categoryViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Category element = (Category)event.getElement();
                element.setActive(event.getChecked());
            }
        });
    }

    protected void createCategoryButtonBar(Composite parent) {
        Composite buttonBar = new Composite(parent, 0);
        buttonBar.setLayoutData((Object)new GridData());
        buttonBar.setLayout((Layout)new FillLayout(512));
        this.addCategoryButton = new Button(buttonBar, 8);
        this.addCategoryButton.setImage(Activator.getDefault().getImage("obj16/add.gif"));
        this.addCategoryButton.setToolTipText(Messages.TracePreferencePage_Label_11_tooltip);
        this.addCategoryButton.addSelectionListener((SelectionListener)new MySelectionListener(this){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Category cat = TraceFactory.eINSTANCE.createCategory();
                cat.setName("name");
                configuration.getCategories().add((Object)cat);
                categoryViewer.refresh();
                categoryViewer.setSelection((ISelection)new StructuredSelection((Object)cat), true);
            }
        });
        this.duplicateCategoryButton = new Button(buttonBar, 8);
        this.duplicateCategoryButton.setImage(Activator.getDefault().getImage("obj16/copy.gif"));
        this.duplicateCategoryButton.setToolTipText(Messages.TracePreferencePage_Label_12_tooltip);
        this.duplicateCategoryButton.addSelectionListener((SelectionListener)new MySelectionListener(this){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Category source = (Category)((IStructuredSelection)categoryViewer.getSelection()).getFirstElement();
                Category catCopy = TraceFactory.eINSTANCE.createCategory();
                catCopy.setName("Copy of " + source.getName());
                catCopy.setActive(source.isActive());
                for (Filter sourcefilter : source.getFilters()) {
                    Filter filter = TraceFactory.eINSTANCE.createFilter();
                    filter.setComment(sourcefilter.getComment());
                    filter.setPattern(sourcefilter.getPattern());
                    catCopy.getFilters().add((Object)filter);
                }
                configuration.getCategories().add((Object)catCopy);
                categoryViewer.refresh();
                categoryViewer.setSelection((ISelection)new StructuredSelection((Object)catCopy), true);
            }
        });
        this.delCategoryButton = new Button(buttonBar, 8);
        this.delCategoryButton.setImage(Activator.getDefault().getImage("obj16/delete.gif"));
        this.delCategoryButton.setToolTipText(Messages.TracePreferencePage_Label_13_tooltip);
        this.delCategoryButton.addSelectionListener((SelectionListener)new MySelectionListener(this){

            @Override
            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)categoryViewer.getSelection();
                Object[] objectArray = ss.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    Category cat = (Category)obj;
                    EcoreUtil.delete((EObject)cat);
                    ++n2;
                }
                categoryViewer.refresh();
                filterViewer.setInput(null);
                this.setButtonStates();
            }
        });
        this.upCategoryButton = new Button(buttonBar, 8);
        this.upCategoryButton.setImage(Activator.getDefault().getImage("obj16/upward.gif"));
        this.upCategoryButton.addSelectionListener((SelectionListener)new MySelectionListener(this){

            @Override
            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)categoryViewer.getSelection();
                Category cat = (Category)ss.getFirstElement();
                EList categories = configuration.getCategories();
                int index = categories.indexOf((Object)cat);
                categories.move(index - 1, (Object)cat);
                categoryViewer.refresh();
                this.setButtonStates();
            }
        });
        this.downCategoryButton = new Button(buttonBar, 8);
        this.downCategoryButton.setImage(Activator.getDefault().getImage("obj16/downward.gif"));
        this.downCategoryButton.addSelectionListener((SelectionListener)new MySelectionListener(this){

            @Override
            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)categoryViewer.getSelection();
                Category cat = (Category)ss.getFirstElement();
                EList categories = configuration.getCategories();
                int index = categories.indexOf((Object)cat);
                categories.move(index + 1, (Object)cat);
                categoryViewer.refresh();
                this.setButtonStates();
            }
        });
    }

    protected void createFilterButtonBar(Composite parent) {
        Composite buttonBar = new Composite(parent, 0);
        buttonBar.setLayoutData((Object)new GridData());
        buttonBar.setLayout((Layout)new FillLayout(512));
        this.addFilterButton = new Button(buttonBar, 8);
        this.addFilterButton.setImage(Activator.getDefault().getImage("obj16/add.gif"));
        this.addFilterButton.setToolTipText(Messages.TracePreferencePage_Label_14_tooltip);
        this.addFilterButton.addSelectionListener((SelectionListener)new MySelectionListener(this){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Category input = (Category)filterViewer.getInput();
                Filter filter = TraceFactory.eINSTANCE.createFilter();
                filter.setComment("//");
                filter.setPattern(".*");
                input.getFilters().add((Object)filter);
                filterViewer.refresh();
                this.setButtonStates();
            }
        });
        this.delFilterButton = new Button(buttonBar, 8);
        this.delFilterButton.setToolTipText(Messages.TracePreferencePage_Label_15_tooltip);
        this.delFilterButton.setImage(Activator.getDefault().getImage("obj16/delete.gif"));
        this.delFilterButton.addSelectionListener((SelectionListener)new MySelectionListener(this){

            @Override
            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)filterViewer.getSelection();
                Object[] objectArray = ss.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    Filter filter = (Filter)obj;
                    EcoreUtil.delete((EObject)filter);
                    ++n2;
                }
                filterViewer.refresh();
                this.setButtonStates();
            }
        });
        this.upFilterButton = new Button(buttonBar, 8);
        this.upFilterButton.setImage(Activator.getDefault().getImage("obj16/upward.gif"));
        this.upFilterButton.addSelectionListener((SelectionListener)new MySelectionListener(this){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Category category = (Category)filterViewer.getInput();
                if (category != null) {
                    IStructuredSelection ss = (IStructuredSelection)filterViewer.getSelection();
                    Filter filter = (Filter)ss.getFirstElement();
                    EList filters = category.getFilters();
                    int index = filters.indexOf((Object)filter);
                    filters.move(index - 1, (Object)filter);
                    filterViewer.refresh();
                    this.setButtonStates();
                }
            }
        });
        this.downFilterButton = new Button(buttonBar, 8);
        this.downFilterButton.setImage(Activator.getDefault().getImage("obj16/downward.gif"));
        this.downFilterButton.addSelectionListener((SelectionListener)new MySelectionListener(this){

            @Override
            public void widgetSelected(SelectionEvent e) {
                Category category = (Category)filterViewer.getInput();
                if (category != null) {
                    IStructuredSelection ss = (IStructuredSelection)filterViewer.getSelection();
                    Filter filter = (Filter)ss.getFirstElement();
                    EList filters = category.getFilters();
                    int index = filters.indexOf((Object)filter);
                    filters.move(index + 1, (Object)filter);
                    filterViewer.refresh();
                    this.setButtonStates();
                }
            }
        });
    }

    protected Composite createComposite(Composite parent, int columns) {
        parent = new Composite(parent, 0);
        parent.setLayoutData((Object)new GridData(1808));
        GridLayout glayout = new GridLayout();
        glayout.numColumns = columns;
        parent.setLayout((Layout)glayout);
        return parent;
    }

    private void setButtonStates() {
        Category category;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.categoryViewer.getSelection();
        int size = selection.size();
        this.addCategoryButton.setEnabled(this.enableSubControl);
        this.delCategoryButton.setEnabled(this.enableSubControl && !selection.isEmpty());
        this.duplicateCategoryButton.setEnabled(this.enableSubControl && size == 1);
        this.upCategoryButton.setEnabled(false);
        this.downCategoryButton.setEnabled(false);
        if (size == 1) {
            EList categories = this.configuration.getCategories();
            int nbCategories = categories.size() - 1;
            index = categories.indexOf(selection.getFirstElement());
            this.upCategoryButton.setEnabled(this.enableSubControl && index > 0);
            this.downCategoryButton.setEnabled(this.enableSubControl && index < nbCategories);
        }
        this.addFilterButton.setEnabled(this.enableSubControl && !selection.isEmpty());
        this.delFilterButton.setEnabled(this.enableSubControl && !this.filterViewer.getSelection().isEmpty());
        this.upFilterButton.setEnabled(false);
        this.downFilterButton.setEnabled(false);
        if (size == 1 && (category = (Category)this.filterViewer.getInput()) != null && !this.filterViewer.getSelection().isEmpty()) {
            int nbFilters = category.getFilters().size() - 1;
            index = category.getFilters().indexOf(((IStructuredSelection)this.filterViewer.getSelection()).getFirstElement());
            this.upFilterButton.setEnabled(this.enableSubControl && index > 0);
            this.downFilterButton.setEnabled(this.enableSubControl && index < nbFilters);
        }
        this.categoryViewer.getTable().setEnabled(this.enableSubControl);
        this.filterViewer.getTable().setEnabled(this.enableSubControl);
    }

    protected Control createContents(Composite parent) {
        Group grp = new Group(parent, 0);
        grp.setText(Messages.TracePreferencePage_Label_7);
        grp.setLayout((Layout)new GridLayout());
        grp.setLayoutData((Object)new GridData(768));
        this.createRadioButtons(grp);
        Composite categoryComposite = this.createComposite(parent, 2);
        this.createCategoryControl(categoryComposite);
        this.createCategoryButtonBar(categoryComposite);
        Composite filterComposite = this.createComposite(parent, 2);
        this.createFilterControl(filterComposite);
        this.createFilterButtonBar(filterComposite);
        this.init();
        this.setButtonStates();
        return parent;
    }

    private void init() {
        try {
            switch (TraceHelper.PREFERENCES.loadState()) {
                case ALWAYS: {
                    this.alwaysBtn.setSelection(true);
                    break;
                }
                case FILTERS: {
                    this.belowBtn.setSelection(true);
                    this.enableSubControl = this.belowBtn.getSelection();
                    break;
                }
                case NEVER: {
                    this.noneBtn.setSelection(true);
                }
            }
            this.configuration = TraceHelper.PREFERENCES.loadConfiguration();
        }
        catch (Exception e) {
            Activator.getDefault().logError(e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.TracePreferencePage_Load_Error_Title, (String)Messages.TracePreferencePage_Load_Error_Message);
            this.configuration = TraceFactory.eINSTANCE.createConfiguration();
        }
        this.categoryViewer.setInput((Object)this.configuration);
    }

    protected void createRadioButtons(Group grp) {
        MySelectionListener listener = new MySelectionListener(this){

            @Override
            public void widgetSelected(SelectionEvent e) {
                enableSubControl = TraceState.FILTERS.equals(e.widget.getData());
                this.setButtonStates();
            }
        };
        this.alwaysBtn = new Button((Composite)grp, 16);
        this.alwaysBtn.setText(Messages.TracePreferencePage_Label_8);
        this.alwaysBtn.setToolTipText(Messages.TracePreferencePage_Label_8_tooltip);
        this.alwaysBtn.setData((Object)TraceState.ALWAYS);
        this.alwaysBtn.addSelectionListener((SelectionListener)listener);
        this.alwaysBtn.setLayoutData((Object)new GridData(768));
        this.belowBtn = new Button((Composite)grp, 16);
        this.belowBtn.setText(Messages.TracePreferencePage_Label_9);
        this.belowBtn.setData((Object)TraceState.FILTERS);
        this.belowBtn.addSelectionListener((SelectionListener)listener);
        this.belowBtn.setLayoutData((Object)new GridData(768));
        this.noneBtn = new Button((Composite)grp, 16);
        this.noneBtn.setText(Messages.TracePreferencePage_Label_10);
        this.noneBtn.setData((Object)TraceState.NEVER);
        this.noneBtn.addSelectionListener((SelectionListener)listener);
        this.noneBtn.setLayoutData((Object)new GridData(768));
    }

    private class MySelectionListener
    implements SelectionListener {
        private MySelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

