/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.activities;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.sirius.ui.helper.ResourceHelper;
import org.polarsys.capella.core.transition.common.activities.AbstractActivity;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.capella.core.transition.system.helpers.ContextHelper;
import org.polarsys.capella.transition.system2subsystem.constants.Messages;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class CopyImagesActivity
extends AbstractActivity {
    public static final String ID = "org.polarsys.capella.transition.system2subsystem.activities.CopyImagesActivity";

    protected IStatus _run(ActivityParameters activityParams) {
        IContext transformationContext = this.getContext(activityParams);
        Project sourceProject = ContextHelper.getSourceProject((IContext)transformationContext);
        Project targetProject = ContextHelper.getTargetProject((IContext)transformationContext);
        IProject sourceEclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(sourceProject.getName());
        IProject targetEclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(targetProject.getName());
        this.copyImagesToTargetProject(sourceEclipseProject, targetEclipseProject);
        return Status.OK_STATUS;
    }

    private void copyImagesToTargetProject(IProject sourceEclipseProject, IProject targetEclipseProject) {
        try {
            for (IResource resource : ResourceHelper.collectImageFiles((IContainer)sourceEclipseProject)) {
                if (targetEclipseProject.exists(resource.getProjectRelativePath())) continue;
                IPath newPath = targetEclipseProject.getFullPath();
                newPath = newPath.addTrailingSeparator();
                newPath = newPath.append(resource.getProjectRelativePath());
                boolean mkdirs = targetEclipseProject.getLocation().addTrailingSeparator().append(resource.getProjectRelativePath()).removeLastSegments(1).toFile().mkdirs();
                if (mkdirs) {
                    targetEclipseProject.refreshLocal(newPath.segmentCount() - 1, null);
                }
                resource.copy(newPath, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException e) {
            LogHelper.getInstance().log(e.getMessage(), (IStatus)new Status(4, "org.polarsys.capella.transition.system2subsystem", e.getMessage(), (Throwable)e), Messages.activityCopyImages);
        }
    }

    public String getActivityIdentifier() {
        return ID;
    }
}

