/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.crossphases.handlers.attachment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.transition.common.capellaHelpers.HashMapSet;
import org.polarsys.capella.core.transition.common.handlers.options.OptionsHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.traceability.TraceabilityHandlerHelper;
import org.polarsys.capella.core.transition.common.rules.AbstractRule;
import org.polarsys.capella.core.transition.system.handlers.attachment.CapellaDefaultAttachmentHandler;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IPremise;

public class CrossPhasesAttachmentHelper
extends CapellaDefaultAttachmentHandler {
    public static final String CROSS_PHASES_ATTACHMENT_HELPER = "CrossPhasesAttachment";
    protected static final String CROSS_PHASES_ATTACHMENT_MAP = "CrossPhasesAttachmentMap";
    protected static final String CROSS_PHASES_ATTACHMENT_REVERSE_MAP = "CrossPhasesAttachmentReverseMap";

    public void computeRelatedComponent(Component element, IContext context_p) {
        Collection transfoSources = (Collection)context_p.get((Object)"TRANSITION_SOURCES");
        Component relatedComponent = element;
        Collection<Part> sourceAndAncestors = this.getSourceAndAncestors(transfoSources);
        if (element != null) {
            boolean shouldMerge = this.shouldMerge(element, context_p);
            if (shouldMerge) {
                this.shouldMerge(element, context_p);
                for (Part part : element.getRepresentingParts()) {
                    if (!sourceAndAncestors.contains(part)) continue;
                    shouldMerge = false;
                }
            }
            if (shouldMerge) {
                for (Part part : element.getRepresentingParts()) {
                    if (!shouldMerge) continue;
                    for (Part source : sourceAndAncestors) {
                        if (!shouldMerge || !ComponentExt.isBrothers((Part)part, (Part)source)) continue;
                        shouldMerge = false;
                    }
                }
            }
            if (shouldMerge) {
                boolean componentFound = false;
                block3: for (Part partElement : element.getRepresentingParts()) {
                    if (componentFound) continue;
                    for (Part part : ComponentExt.getBestPartAncestors((Part)partElement)) {
                        Component type;
                        Component cache2;
                        if (componentFound || !(part.getAbstractType() instanceof Component) || (cache2 = this.getRelatedComponent(type = (Component)part.getAbstractType(), context_p)) == null) continue;
                        relatedComponent = cache2;
                        componentFound = true;
                        continue block3;
                    }
                }
            }
        }
        if (relatedComponent != null) {
            CrossPhasesAttachmentHelper.getInstance(context_p).setRelatedComponent(element, relatedComponent, context_p);
        }
    }

    protected boolean shouldMerge(Component element_p, IContext context_p) {
        return element_p instanceof PhysicalComponent || OptionsHandlerHelper.getInstance((IContext)context_p).getBooleanValue(context_p, "capella.core.transition.system2subsystem.crossphases", "componentMerge", true);
    }

    private Collection<Part> getSourceAndAncestors(Collection<EObject> transfoSources_p) {
        HashSet<Part> sources = new HashSet<Part>();
        for (EObject eObject : transfoSources_p) {
            if (eObject instanceof Part) {
                sources.add((Part)eObject);
                sources.addAll(ComponentExt.getPartAncestors((Part)((Part)eObject)));
                continue;
            }
            if (!(eObject instanceof Component)) continue;
            for (Part part : ((Component)eObject).getRepresentingParts()) {
                sources.add(part);
                sources.addAll(ComponentExt.getPartAncestors((Part)part));
            }
        }
        return sources;
    }

    private boolean isBrotherWithSource(Component element_p, Collection<EObject> transfoSources_p) {
        HashSet<Part> sources = new HashSet<Part>();
        for (EObject eObject : transfoSources_p) {
            if (eObject instanceof Part) {
                sources.add((Part)eObject);
                continue;
            }
            if (!(eObject instanceof Component)) continue;
            for (Part part : ((Component)eObject).getRepresentingParts()) {
                sources.add(part);
            }
        }
        for (Part part : element_p.getRepresentingParts()) {
            for (Part source : sources) {
                if (!ComponentExt.isBrothers((Part)part, (Part)source)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAncestorOf(Component element_p, Collection<EObject> transfoSources_p) {
        for (EObject source : transfoSources_p) {
            if (source instanceof Part) {
                for (Part part : ComponentExt.getPartAncestors((Part)((Part)source))) {
                    if (!element_p.equals(part.getAbstractType())) continue;
                    return true;
                }
                continue;
            }
            if (!(source instanceof Component)) continue;
            for (Part partSource : ((Component)source).getRepresentingParts()) {
                if (!(partSource instanceof Part)) continue;
                for (Part part : ComponentExt.getPartAncestors((Part)partSource)) {
                    if (!element_p.equals(part.getAbstractType())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static CrossPhasesAttachmentHelper getInstance(IContext context_p) {
        CrossPhasesAttachmentHelper handler = (CrossPhasesAttachmentHelper)((Object)context_p.get((Object)CROSS_PHASES_ATTACHMENT_HELPER));
        if (handler == null) {
            handler = new CrossPhasesAttachmentHelper();
            handler.init(context_p);
            context_p.put((Object)CROSS_PHASES_ATTACHMENT_HELPER, (Object)handler);
        }
        return handler;
    }

    public Component getRelatedComponent(Component source, IContext context_p) {
        Component cache = (Component)this.getMap(context_p).get(source);
        if (cache == null) {
            this.computeRelatedComponent(source, context_p);
            cache = (Component)this.getMap(context_p).get(source);
        }
        if (cache == null) {
            cache = source;
        }
        this.computeRelatedComponent(source, context_p);
        return cache;
    }

    public void setRelatedComponent(Component source, Component target, IContext context_p) {
        this.getMap(context_p).put((EObject)source, (EObject)target);
        this.getReverseMap(context_p).put((Object)target, (Object)source);
    }

    protected HashMapSet<EObject, EObject> getReverseMap(IContext context_p) {
        if (context_p.get((Object)CROSS_PHASES_ATTACHMENT_REVERSE_MAP) == null) {
            context_p.put((Object)CROSS_PHASES_ATTACHMENT_REVERSE_MAP, (Object)new HashMapSet());
        }
        return (HashMapSet)context_p.get((Object)CROSS_PHASES_ATTACHMENT_REVERSE_MAP);
    }

    public Map<EObject, EObject> getMap(IContext context_p) {
        if (context_p.get((Object)CROSS_PHASES_ATTACHMENT_MAP) == null) {
            context_p.put((Object)CROSS_PHASES_ATTACHMENT_MAP, new HashMap());
        }
        return (Map)context_p.get((Object)CROSS_PHASES_ATTACHMENT_MAP);
    }

    public void clear(IContext context) {
        this.getMap(context).clear();
        this.getReverseMap(context).clear();
    }

    public IStatus init(IContext context_p) {
        return Status.OK_STATUS;
    }

    public IStatus dispose(IContext context_p) {
        return Status.OK_STATUS;
    }

    public void attachRelatedElements(EObject source_p, EObject target_p, EReference feature_p, IContext context_p) {
        for (EObject traced : this.retrieveReferenceAsList(source_p, feature_p)) {
            if (traced instanceof Component) {
                traced = this.getRelatedComponent((Component)traced, context_p);
            }
            for (EObject related : TraceabilityHandlerHelper.getInstance((IContext)context_p).retrieveTracedElements(traced, context_p)) {
                this.attachElementByReference(source_p, target_p, traced, related, feature_p, feature_p);
            }
        }
    }

    public void attachRelatedOfMergedElements(EObject element_p, EObject result_p, EReference reference_p, IContext context_p) {
        Collection values = this.getReverseMap(context_p).get((Object)element_p);
        if (values != null && values.size() > 0) {
            for (EObject value : values) {
                if (value == null || element_p.equals(value)) continue;
                this.attachRelatedElements(value, result_p, reference_p, context_p);
            }
        }
    }

    public void addPremicesRelatedOfMergedComponent(EObject element_p, AbstractRule rule, EReference feature, ArrayList<IPremise> needed_p, IContext context_p) {
        Collection values = this.getReverseMap(context_p).get((Object)element_p);
        if (values != null && values.size() > 0) {
            for (EObject value : values) {
                if (value == null || element_p.equals(value)) continue;
                needed_p.addAll(rule.createDefaultPrecedencePremices(value, feature));
            }
        }
    }
}

