/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.sirius.ui;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.diagramtype.DiagramTypeDescriptorRegistry;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramTypeDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.FilteringModel;
import org.polarsys.capella.filtering.FilteringResults;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class FilteringSiriusUtils {
    private FilteringSiriusUtils() {
    }

    public static FilteringModel getFilteringModel(DDiagram diagram) {
        List<FilteringModel> filteringModels = FilteringSiriusUtils.getFilteringModels(diagram, false);
        return !filteringModels.isEmpty() ? filteringModels.get(0) : null;
    }

    public static List<FilteringModel> getFilteringModels(DDiagram diagram, boolean includeReferencedLibraries) {
        DAnalysis dAnalysis = new EObjectQuery((EObject)diagram).getDAnalysis();
        EList models = dAnalysis.getModels();
        HashSet result = new HashSet();
        if (models != null && !models.isEmpty()) {
            for (EObject project : models) {
                result.addAll(FilteringUtils.getFilteringModels((EObject)project, (boolean)includeReferencedLibraries));
            }
        }
        return new ArrayList<FilteringModel>(result);
    }

    public static FilteringResults getFilteringResults(DDiagram diagram) {
        EObject dAnalysis = EcoreUtil.getRootContainer((EObject)diagram);
        EList models = ((DAnalysis)dAnalysis).getModels();
        if (models != null && !models.isEmpty()) {
            for (EObject project : models) {
                FilteringResults configurations = FilteringUtils.getFilteringResults((EObject)project);
                if (configurations == null) continue;
                return configurations;
            }
        }
        return null;
    }

    public static Set<Object> getAllVisibleElements(DDiagram diagram) {
        HashSet set = Sets.newHashSet();
        for (DDiagramElement o : diagram.getDiagramElements()) {
            if (!o.isVisible()) continue;
            set.add(o);
        }
        return set;
    }

    public static Set<Object> getAllInvisibleElements(DDiagram diagram) {
        HashSet set = Sets.newHashSet();
        for (DDiagramElement o : diagram.getDiagramElements()) {
            if (o.isVisible()) continue;
            set.add(o);
        }
        return set;
    }

    public static boolean allElementsAssociatedToAFeatureAreVisible(DDiagram diagram, EnumerationPropertyLiteral feature) {
        for (Object o : FilteringSiriusUtils.getAllInvisibleElements(diagram)) {
            if (!(o instanceof DDiagramElement)) continue;
            DDiagramElement diagramElement = (DDiagramElement)o;
            for (EObject semanticElement : FilteringSiriusUtils.getRealSemanticElements(diagramElement)) {
                if (!FilteringUtils.getAssociatedCriteria((EObject)semanticElement).contains(feature)) continue;
                return false;
            }
        }
        return true;
    }

    public static List<DDiagramElement> getAllElementsAssociatedToAFeature(DDiagram diagram, FilteringCriterion feature, boolean includeCommon) {
        ArrayList<DDiagramElement> result = new ArrayList<DDiagramElement>();
        block0: for (Object o : diagram.getDiagramElements()) {
            if (!(o instanceof DDiagramElement)) continue;
            DDiagramElement diagramElement = (DDiagramElement)o;
            for (EObject semanticElement : FilteringSiriusUtils.getRealSemanticElements(diagramElement)) {
                List associatedCriteria = FilteringUtils.getAssociatedCriteria((EObject)semanticElement);
                if (includeCommon && (associatedCriteria == null || associatedCriteria.isEmpty()) && !result.contains(diagramElement)) {
                    result.add(diagramElement);
                    continue block0;
                }
                if (associatedCriteria == null || !associatedCriteria.contains(feature) || result.contains(diagramElement)) continue;
                result.add(diagramElement);
                continue block0;
            }
        }
        return result;
    }

    public static boolean hasAssociatedCriteria(DDiagramElement element) {
        for (EObject eObject : FilteringSiriusUtils.getRealSemanticElements(element)) {
            if (!FilteringUtils.getAssociatedCriteria((EObject)eObject).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static List<EObject> getRealSemanticElements(DDiagramElement element) {
        DEdge edge;
        EdgeTarget edgeTarget;
        ArrayList<EObject> semanticElements = new ArrayList<EObject>();
        if (!element.getSemanticElements().isEmpty()) {
            return element.getSemanticElements();
        }
        if (element instanceof DEdge && (edgeTarget = (edge = (DEdge)element).getSourceNode()) instanceof DDiagramElement) {
            return FilteringSiriusUtils.getRealSemanticElements((DDiagramElement)edgeTarget);
        }
        return semanticElements;
    }

    public static List<ExtensibleElement> getCapellaElements(DDiagramElement element) {
        ArrayList<ExtensibleElement> melodyElements = new ArrayList<ExtensibleElement>();
        for (EObject e : FilteringSiriusUtils.getRealSemanticElements(element)) {
            if (!(e instanceof ExtensibleElement)) continue;
            melodyElements.add((ExtensibleElement)e);
        }
        return melodyElements;
    }

    public static boolean containsCapellaElements(DDiagramElement element) {
        for (EObject e : element.getSemanticElements()) {
            if (!(e instanceof ExtensibleElement)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAssociatedCriteria(DDiagramElement element) {
        for (ExtensibleElement me : FilteringSiriusUtils.getCapellaElements(element)) {
            if (FilteringUtils.getAssociatedCriteria((EObject)me).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean containsExplicitAssociatedCriteria(DDiagramElement element) {
        for (ExtensibleElement me : FilteringSiriusUtils.getCapellaElements(element)) {
            if (FilteringUtils.getExplicitAssociatedCriteria((EObject)me).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean allElementsAssociatedToAFeatureAreInTheList(DDiagram diagram, List<?> elements, FilteringCriterion feature) {
        List<DDiagramElement> associatedElements = FilteringSiriusUtils.getAllElementsAssociatedToAFeature(diagram, feature, false);
        return !associatedElements.isEmpty() && elements.containsAll(associatedElements);
    }

    public static Predicate<DDiagramElement> allowsHideReveal(DDiagram diagram) {
        Predicate result = Predicates.alwaysTrue();
        if (diagram == null || diagram.getDescription() == null || !FilteringSiriusUtils.isEditable(diagram)) {
            return Predicates.alwaysFalse();
        }
        for (final IDiagramTypeDescriptor diagramTypeDescriptor : DiagramTypeDescriptorRegistry.getInstance().getAllDiagramTypeDescriptors()) {
            Predicate<DDiagramElement> allowsHideReveal;
            if (!diagramTypeDescriptor.getDiagramDescriptionProvider().handles(diagram.getDescription().eClass().getEPackage()) || (allowsHideReveal = new Predicate<DDiagramElement>(){

                public boolean apply(DDiagramElement element) {
                    return diagramTypeDescriptor.getDiagramDescriptionProvider().allowsHideReveal(element);
                }
            }) == null) continue;
            result = allowsHideReveal;
            break;
        }
        return result;
    }

    public static boolean isEditable(DDiagram diagram) {
        IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(diagram.eResource().getResourceSet());
        return permissionAuthority.canEditInstance((EObject)diagram);
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        if (win != null) {
            return win.getActivePage();
        }
        return null;
    }

    public static IDiagramWorkbenchPart getActivePart() {
        IWorkbenchPart workbenchPart;
        IWorkbenchPage activePage = FilteringSiriusUtils.getActivePage();
        if (activePage != null && (workbenchPart = activePage.getActivePart()) instanceof IDiagramWorkbenchPart) {
            return (IDiagramWorkbenchPart)workbenchPart;
        }
        return null;
    }

    public static String getCommaSeparatedFeatures(DDiagramElement element) {
        List<FilteringCriterion> featureList = FilteringSiriusUtils.getAssociatedCriteria(element);
        if (featureList.isEmpty()) {
            return null;
        }
        String features = "";
        for (FilteringCriterion feature : featureList) {
            features = String.valueOf(features) + feature.getName() + ", ";
        }
        if (features.length() > 0) {
            features = features.substring(0, features.length() - ", ".length());
        }
        return features;
    }

    public static String getEnterSeparatedExplicitFeatures(DDiagramElement element, boolean sort) {
        List<FilteringCriterion> featureList = FilteringSiriusUtils.getExplicitAssociatedCriteria(element);
        if (featureList.isEmpty()) {
            return null;
        }
        Object[] strings = new String[featureList.size()];
        int x = 0;
        while (x < featureList.size()) {
            strings[x] = featureList.get(x).getName();
            ++x;
        }
        if (sort) {
            Arrays.sort(strings);
        }
        String features = "";
        Object[] objectArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            Object feature = objectArray[n2];
            features = String.valueOf(features) + (String)feature + "\n";
            ++n2;
        }
        if (features.length() > 0) {
            features = features.substring(0, features.length() - "\n".length());
        }
        return features;
    }

    public static List<FilteringCriterion> getAssociatedCriteria(DDiagramElement element) {
        ArrayList<FilteringCriterion> featureList = new ArrayList<FilteringCriterion>();
        for (EObject semanticObject : element.getSemanticElements()) {
            for (FilteringCriterion feature : FilteringUtils.getAssociatedCriteria((EObject)semanticObject)) {
                if (featureList.contains(feature)) continue;
                featureList.add(feature);
            }
        }
        return featureList;
    }

    public static List<FilteringCriterion> getExplicitAssociatedCriteria(DDiagramElement element) {
        ArrayList<FilteringCriterion> featureList = new ArrayList<FilteringCriterion>();
        for (EObject semanticObject : element.getSemanticElements()) {
            for (FilteringCriterion feature : FilteringUtils.getExplicitAssociatedCriteria((EObject)semanticObject)) {
                if (featureList.contains(feature)) continue;
                featureList.add(feature);
            }
        }
        return featureList;
    }
}

