/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.sirius.ui.diagram.actions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.tools.api.layout.PinHelper;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.polarsys.capella.filtering.sirius.ui.Activator;
import org.polarsys.capella.filtering.sirius.ui.FilteringSiriusUtils;
import org.polarsys.capella.filtering.sirius.ui.diagram.actions.FilteringDiagramAction;
import org.polarsys.capella.filtering.sirius.ui.dialogs.DiagramElementsSelectionDialog;

public class SelectPinnedCriteriaAction
extends FilteringDiagramAction {
    private static final String TITLE = "Diagram Filtering Features pinning";
    private static final String MESSAGE = "Pinned diagram Filtering Features are checked.";
    private static final String TOOLTIP = "Pin/Unpin features";
    private static final String ICON_PATH = "icons/pinUnpinCriteria.png";
    private static final ImageDescriptor DESC_PIN = Activator.getBundledImageDescriptor("icons/pinUnpinCriteria.png");
    private final Predicate<Object> isPinned = new Predicate<Object>(){

        public boolean apply(Object input) {
            if (input instanceof DDiagramElement) {
                return new PinHelper().isPinned((DDiagramElement)input);
            }
            return false;
        }
    };
    private final Function<Object, Void> pinElement = new Function<Object, Void>(){

        public Void apply(Object from) {
            if (from instanceof DDiagramElement) {
                new PinHelper().markAsPinned((DDiagramElement)from);
            }
            return null;
        }
    };
    private final Function<Object, Void> unpinElement = new Function<Object, Void>(){

        public Void apply(Object from) {
            if (from instanceof DDiagramElement) {
                new PinHelper().markAsUnpinned((DDiagramElement)from);
            }
            return null;
        }
    };

    public SelectPinnedCriteriaAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
        this.setImageDescriptor(DESC_PIN);
    }

    public SelectPinnedCriteriaAction(IWorkbenchPage workbenchPage, IDiagramWorkbenchPart part) {
        super(workbenchPage);
        this.setWorkbenchPart((IWorkbenchPart)part);
        this.setImageDescriptor(this.getImage());
    }

    public ImageDescriptor getImage() {
        EObject diagram;
        Diagram gmfDiagram;
        if (this.getWorkbenchPart() instanceof DiagramEditor && (gmfDiagram = ((DiagramEditor)this.getWorkbenchPart()).getDiagram()) != null && (diagram = gmfDiagram.getElement()) instanceof DDiagram && this.hasPinnedAndOptionalElements((DDiagram)diagram)) {
            return DESC_PIN;
        }
        return DESC_PIN;
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected boolean isSelectionListener() {
        return false;
    }

    private Shell getShell() {
        return this.getWorkbenchPart().getSite().getShell();
    }

    protected Command getCommand() {
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        Iterable diagramEditParts = Iterables.filter((Iterable)this.getSelectedObjects(), IDDiagramEditPart.class);
        if (Iterables.size((Iterable)diagramEditParts) >= 1) {
            IDDiagramEditPart diagramEditPart = (IDDiagramEditPart)Iterables.get((Iterable)diagramEditParts, (int)0);
            result = this.getElementsSelectionCommand(diagramEditPart);
        }
        return result;
    }

    private Command getElementsSelectionCommand(IDDiagramEditPart diagramEditPart) {
        EObject semanticElement = diagramEditPart.resolveSemanticElement();
        if (semanticElement instanceof DDiagram) {
            DDiagram diagram = (DDiagram)semanticElement;
            return new ICommandProxy((ICommand)new HiddenFeaturesSelectionCommand(diagramEditPart.getEditingDomain(), TOOLTIP, diagram));
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected boolean calculateEnabled() {
        boolean canEditInstance = true;
        if (this.getWorkbenchPart() instanceof DDiagramEditor && ((DDiagramEditor)this.getWorkbenchPart()).getRepresentation() instanceof DDiagram) {
            DDiagramEditor editor = (DDiagramEditor)this.getWorkbenchPart();
            DDiagram editorDiagram = (DDiagram)editor.getRepresentation();
            IPermissionAuthority permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(editor.getSession().getSessionResource().getResourceSet());
            canEditInstance = permissionAuthority.canEditInstance((EObject)editorDiagram);
        }
        return canEditInstance && super.calculateEnabled();
    }

    private boolean hasPinnedAndOptionalElements(DDiagram dDiagram) {
        Iterator iterator = dDiagram.getDiagramElements().iterator();
        PinHelper pinHelper = new PinHelper();
        while (iterator.hasNext()) {
            DDiagramElement element = (DDiagramElement)iterator.next();
            if (!pinHelper.isPinned(element) || !FilteringSiriusUtils.hasAssociatedCriteria(element)) continue;
            return true;
        }
        return false;
    }

    public void setWorkbenchPart(IWorkbenchPart workbenchPart) {
        super.setWorkbenchPart(workbenchPart);
    }

    private final class HiddenFeaturesSelectionCommand
    extends AbstractTransactionalCommand {
        private final DDiagram diagram;

        private HiddenFeaturesSelectionCommand(TransactionalEditingDomain domain, String label, DDiagram diagram) {
            super(domain, label, null);
            this.diagram = diagram;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            DiagramElementsSelectionDialog dlg = new DiagramElementsSelectionDialog(SelectPinnedCriteriaAction.TITLE, SelectPinnedCriteriaAction.MESSAGE);
            dlg.setSelectionPredicate((Predicate<Object>)SelectPinnedCriteriaAction.this.isPinned);
            dlg.setSelectedAction((Function<Object, Void>)SelectPinnedCriteriaAction.this.pinElement);
            dlg.setDeselectedAction((Function<Object, Void>)SelectPinnedCriteriaAction.this.unpinElement);
            dlg.setGrayedPredicate(this.getNonSelectablePredicate());
            boolean executed = dlg.open(SelectPinnedCriteriaAction.this.getShell(), this.diagram, true);
            if (executed) {
                return CommandResult.newOKCommandResult();
            }
            return CommandResult.newCancelledCommandResult();
        }

        private Predicate<Object> getNonSelectablePredicate() {
            return new Predicate<Object>(){

                public boolean apply(Object input) {
                    if (input instanceof DDiagramElement) {
                        return !PinHelper.allowsPinUnpin((DDiagramElement)((DDiagramElement)input));
                    }
                    return false;
                }
            };
        }
    }
}

