/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.sirius.ui.diagram.actions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.helper.graphicalfilters.HideFilterHelper;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.business.api.provider.AbstractDDiagramElementLabelItemProvider;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.filtering.sirius.ui.Activator;
import org.polarsys.capella.filtering.sirius.ui.FilteringSiriusUtils;
import org.polarsys.capella.filtering.sirius.ui.diagram.actions.FilteringDiagramAction;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;

public class FilterCommonOptionalAction
extends FilteringDiagramAction {
    private boolean common;
    private static final String DIAGRAM_ANNOTATION = "Filter";
    private String DIAGRAM_ANNOTATION_SUFFIX = null;
    private static final String ICON_PATH = "icons/filters.png";
    private static final ImageDescriptor DESC_FILTER = Activator.getBundledImageDescriptor("icons/filters.png");
    private final Predicate<Object> isVisible = new Predicate<Object>(){

        public boolean apply(Object input) {
            Option optionTarget;
            boolean result = false;
            if (input instanceof DDiagramElement) {
                result = !new DDiagramElementQuery((DDiagramElement)input).isHidden();
            } else if (input instanceof AbstractDDiagramElementLabelItemProvider && (optionTarget = ((AbstractDDiagramElementLabelItemProvider)input).getDiagramElementTarget()).some()) {
                result = !new DDiagramElementQuery((DDiagramElement)optionTarget.get()).isLabelHidden();
            }
            return result;
        }
    };

    public FilterCommonOptionalAction(IWorkbenchPage workbenchPage, IDiagramWorkbenchPart part, boolean isCommon) {
        super(workbenchPage);
        this.setWorkbenchPart((IWorkbenchPart)part);
        this.setImageDescriptor(this.getImage());
        this.common = isCommon;
        this.DIAGRAM_ANNOTATION_SUFFIX = this.common ? "Common" : "Optionals";
    }

    public ImageDescriptor getImage() {
        return DESC_FILTER;
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected boolean isSelectionListener() {
        return false;
    }

    protected Command getCommand() {
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        Iterable diagramEditParts = Iterables.filter((Iterable)this.getSelectedObjects(), IDDiagramEditPart.class);
        if (Iterables.size((Iterable)diagramEditParts) >= 1) {
            IDDiagramEditPart diagramEditPart = (IDDiagramEditPart)Iterables.get((Iterable)diagramEditParts, (int)0);
            result = this.getElementsSelectionCommand(diagramEditPart);
        }
        return result;
    }

    private Command getElementsSelectionCommand(IDDiagramEditPart diagramEditPart) {
        EObject semanticElement = diagramEditPart.resolveSemanticElement();
        if (semanticElement instanceof DDiagram) {
            DDiagram diagram = (DDiagram)semanticElement;
            return new ICommandProxy((org.eclipse.gmf.runtime.common.core.command.ICommand)new FilterCommonOptionalCommand(diagramEditPart.getEditingDomain(), "", diagram));
        }
        return UnexecutableCommand.INSTANCE;
    }

    public void setShow(boolean show) {
        EObject diagram;
        Diagram gmfDiagram;
        if (this.getWorkbenchPart() instanceof DiagramEditor && (gmfDiagram = ((DiagramEditor)this.getWorkbenchPart()).getDiagram()) != null && (diagram = gmfDiagram.getElement()) instanceof DDiagram) {
            final DDiagram dDiagram = (DDiagram)diagram;
            final DAnnotation dAnnotation = dDiagram.getDAnnotation(DIAGRAM_ANNOTATION + this.DIAGRAM_ANNOTATION_SUFFIX);
            AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

                public void run() {
                    if (dAnnotation == null) {
                        DAnnotation dAnnotation1 = DescriptionFactory.eINSTANCE.createDAnnotation();
                        dAnnotation1.setSource(FilterCommonOptionalAction.DIAGRAM_ANNOTATION + FilterCommonOptionalAction.this.DIAGRAM_ANNOTATION_SUFFIX);
                        dDiagram.getEAnnotations().add((Object)dAnnotation1);
                    } else {
                        dDiagram.getEAnnotations().remove((Object)dAnnotation);
                    }
                }
            };
            FilteringUtils.executeCommand((ICommand)command, (EObject)diagram);
        }
    }

    public boolean getShow() {
        return this.isAlreadyFiltered();
    }

    public boolean isAlreadyFiltered() {
        DDiagram dDiagram;
        DAnnotation dAnnotation;
        EObject diagram;
        Diagram gmfDiagram;
        return this.getWorkbenchPart() instanceof DiagramEditor && (gmfDiagram = ((DiagramEditor)this.getWorkbenchPart()).getDiagram()) != null && (diagram = gmfDiagram.getElement()) instanceof DDiagram && (dAnnotation = (dDiagram = (DDiagram)diagram).getDAnnotation(DIAGRAM_ANNOTATION + this.DIAGRAM_ANNOTATION_SUFFIX)) != null;
    }

    public void setWorkbenchPart(IWorkbenchPart workbenchPart) {
        super.setWorkbenchPart(workbenchPart);
    }

    private final class FilterCommonOptionalCommand
    extends AbstractTransactionalCommand {
        private final DDiagram diagram;
        private final Function<Object, Void> hideElement;
        private final Function<Object, Void> revealElement;

        private FilterCommonOptionalCommand(TransactionalEditingDomain domain, String label, DDiagram diagram) {
            super(domain, label, null);
            this.hideElement = new Function<Object, Void>(){

                public Void apply(Object from) {
                    Option optionTarget;
                    if (from instanceof DDiagramElement) {
                        HideFilterHelper.INSTANCE.hide((DDiagramElement)from);
                    } else if (from instanceof AbstractDDiagramElementLabelItemProvider && (optionTarget = ((AbstractDDiagramElementLabelItemProvider)from).getDiagramElementTarget()).some()) {
                        HideFilterHelper.INSTANCE.hideLabel((DDiagramElement)optionTarget.get());
                    }
                    return null;
                }
            };
            this.revealElement = new Function<Object, Void>(){

                public Void apply(Object from) {
                    if (from instanceof DDiagramElement) {
                        HideFilterHelper.INSTANCE.reveal((DDiagramElement)from);
                    } else if (from instanceof AbstractDDiagramElementLabelItemProvider) {
                        HideFilterHelper.INSTANCE.revealLabel((DDiagramElement)((AbstractDDiagramElementLabelItemProvider)from).getTarget());
                    }
                    return null;
                }
            };
            this.diagram = diagram;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            boolean executed = false;
            Set<Object> allSelectedElements = Collections.unmodifiableSet(this.getAllSelectedElements());
            Set<Object> selectedAfterSet = this.getElementsSelectedAfter();
            Option response = Options.newSome(selectedAfterSet);
            if (response.some()) {
                Set selectedAfter = (Set)response.get();
                this.applyRequestedChanges(allSelectedElements, selectedAfter);
                assert (selectedAfter.equals(allSelectedElements));
                executed = true;
            }
            if (executed) {
                return CommandResult.newOKCommandResult();
            }
            return CommandResult.newCancelledCommandResult();
        }

        private Set<Object> getElementsSelectedAfter() {
            HashSet set = Sets.newHashSet();
            EList treeElements = this.diagram.getDiagramElements();
            boolean show = FilterCommonOptionalAction.this.getShow();
            for (DDiagramElement element : treeElements) {
                boolean hasFeatures = FilteringSiriusUtils.hasAssociatedCriteria(element);
                if (!show || (!FilterCommonOptionalAction.this.common || hasFeatures) && (FilterCommonOptionalAction.this.common || !hasFeatures)) continue;
                set.add(element);
            }
            return set;
        }

        protected Set<Object> getAllSelectedElements() {
            HashSet set = Sets.newHashSet();
            EList treeElements = this.diagram.getDiagramElements();
            for (DDiagramElement element : treeElements) {
                if (!FilterCommonOptionalAction.this.isVisible.apply((Object)element) || (!FilterCommonOptionalAction.this.common || FilteringSiriusUtils.hasAssociatedCriteria(element)) && (FilterCommonOptionalAction.this.common || !FilteringSiriusUtils.hasAssociatedCriteria(element))) continue;
                set.add(element);
            }
            return set;
        }

        protected void applyRequestedChanges(Set<Object> selectedBefore, Set<Object> selectedAfter) {
            for (Object dde : Sets.difference(selectedBefore, selectedAfter)) {
                this.hideElement.apply(dde);
            }
            for (Object dde : Sets.difference(selectedAfter, selectedBefore)) {
                this.revealElement.apply(dde);
            }
        }
    }
}

