/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.common;

import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.skeleton.CapellaModelSkeleton;
import org.polarsys.capella.cybersecurity.model.activator.CybersecurityModelActivator;
import org.polarsys.capella.cybersecurity.test.common.TransactionalEditingDomainHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public abstract class BasicDynamicModelTest
extends BasicTestCase {
    public static final String PA = "PA";
    public static final String SA = "SA";
    public static final String LA = "LA";
    public static final String OA = "OA";
    public static final EClass PC = PaPackage.Literals.PHYSICAL_COMPONENT;
    public static final EClass PF = PaPackage.Literals.PHYSICAL_FUNCTION;
    public static final EClass CP = FaPackage.Literals.COMPONENT_PORT;
    public static final EClass FIP = FaPackage.Literals.FUNCTION_INPUT_PORT;
    public static final EClass FOP = FaPackage.Literals.FUNCTION_OUTPUT_PORT;
    public static final EClass FE = FaPackage.Literals.FUNCTIONAL_EXCHANGE;
    public static final EClass I = CsPackage.Literals.INTERFACE;
    public static final EClass EI = InformationPackage.Literals.EXCHANGE_ITEM;
    public static final EClass CE = FaPackage.Literals.COMPONENT_EXCHANGE;
    public static final EClass PP = CsPackage.Literals.PHYSICAL_PORT;
    public static final EClass PL = CsPackage.Literals.PHYSICAL_LINK;
    public static final EClass LC = LaPackage.Literals.LOGICAL_COMPONENT;
    public static final EClass LF = LaPackage.Literals.LOGICAL_FUNCTION;
    public static final EClass SC = CtxPackage.Literals.SYSTEM_COMPONENT;
    public static final EClass SF = CtxPackage.Literals.SYSTEM_FUNCTION;
    public static final EClass OAC = OaPackage.Literals.OPERATIONAL_ACTIVITY;
    public static final EClass OE = OaPackage.Literals.ENTITY;
    protected ExecutionManager manager;
    protected CapellaModelSkeleton skeleton;
    protected TransactionalEditingDomainHelper tedHelper;
    protected Project project;

    public void setUp() throws Exception {
        super.setUp();
        this.manager = ExecutionManagerRegistry.getInstance().addNewManager();
        this.tedHelper = new TransactionalEditingDomainHelper(this.manager.getEditingDomain());
        this.skeleton = new CapellaModelSkeleton.Builder(this.manager).setURI(URI.createPlatformResourceURI((String)"/project/project.capella", (boolean)false)).setName("project").build();
        Notifier target = this.skeleton.getTarget();
        if (target instanceof Project) {
            this.project = (Project)target;
            this.executeCommand(() -> new CybersecurityModelActivator().addProjectCybersecurityConfig(this.project));
        }
        this.executeCommand(() -> this.initModel(this.skeleton));
    }

    public void tearDown() {
        ExecutionManagerRegistry.getInstance().removeManager(this.manager);
    }

    protected final void executeCommand(Runnable runnable, Map<?, ?> options) throws RollbackException, InterruptedException {
        this.tedHelper.executeCommand(runnable, options);
    }

    protected final void executeCommand(Runnable runnable) throws RollbackException, InterruptedException {
        this.executeCommand(runnable, Collections.emptyMap());
    }

    protected abstract void initModel(CapellaModelSkeleton var1);

    protected final void undo() {
        ((TransactionalCommandStack)this.manager.getEditingDomain().getCommandStack()).undo();
    }

    public <T extends EObject> T create(EObject container, EClass zzz) {
        EObject result = EcoreUtil.create((EClass)zzz);
        Command command = AddCommand.create((EditingDomain)this.manager.getEditingDomain(), (Object)container, null, (Object)result);
        if (command.canExecute()) {
            command.execute();
            CapellaElementExt.creationService((EObject)result);
            return (T)result;
        }
        throw new IllegalArgumentException("Cannot add " + result + " to " + container);
    }
}

