/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class PluginCustomizationTest
extends BasicTestCase {
    public void test() throws Exception {
        String ini = Platform.getProduct().getProperty("preferenceCustomization");
        Properties capellaIni = this.loadProperties(Platform.getBundle((String)"org.polarsys.capella.rcp").getResource(ini));
        Properties cybersecurityIni = this.loadProperties(Platform.getBundle((String)"org.polarsys.capella.cybersecurity.rcp").getResource(ini));
        ArrayList<String> errors = new ArrayList<String>();
        for (Object key : capellaIni.keySet()) {
            if (!cybersecurityIni.containsKey(key)) {
                errors.add(NLS.bind((String)"Missing key: {0}", (Object)key));
                continue;
            }
            if (!cybersecurityIni.containsKey(key) || capellaIni.get(key).equals(cybersecurityIni.get(key))) continue;
            errors.add(NLS.bind((String)"Different value for key: {0}: {1}", (Object)key, (Object)capellaIni.get(key)));
        }
        PluginCustomizationTest.assertTrue((String)(String.valueOf(NLS.bind((String)"Errors in plugin customization: {0}\n", (Object)ini)) + errors.stream().collect(Collectors.joining("\n"))), (boolean)errors.isEmpty());
    }

    private Properties loadProperties(URL url) {
        Properties result;
        block12: {
            PluginCustomizationTest.assertNotNull((Object)url);
            result = new Properties();
            InputStream input = null;
            try {
                try {
                    input = url.openStream();
                    result.load(input);
                }
                catch (IOException e) {
                    PluginCustomizationTest.assertTrue((String)e.getMessage(), (boolean)false);
                    if (input == null) break block12;
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return result;
    }
}

