/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.diagram;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.FlatContainerStyle;
import org.eclipse.sirius.diagram.Square;
import org.eclipse.sirius.diagram.impl.SquareImpl;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.Style;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeAllocation;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.pa.PhysicalFunction;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.CybersecurityQueries;
import org.polarsys.capella.cybersecurity.model.FunctionStorage;
import org.polarsys.capella.cybersecurity.model.FunctionalPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.InformationPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;
import org.polarsys.capella.cybersecurity.model.PrimaryAssetMember;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.model.TrustBoundaryStorage;
import org.polarsys.capella.cybersecurity.sirius.analysis.CybersecurityServices;
import org.polarsys.capella.cybersecurity.test.common.Allocators;
import org.polarsys.capella.cybersecurity.test.common.TransactionalEditingDomainHelper;
import org.polarsys.capella.cybersecurity.test.diagram.CyberDiagramLayers;
import org.polarsys.capella.cybersecurity.test.diagram.CyberPABDiagram;
import org.polarsys.capella.test.diagram.tools.ju.model.EmptyProject;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;

public class CyberPABDiagramTest
extends EmptyProject {
    protected TransactionalEditingDomainHelper tedHelper;
    private FunctionalPrimaryAsset fpa;
    private InformationPrimaryAsset ipa;
    private Threat threat;

    protected void undoAllChanges() {
    }

    protected void setUp() throws Exception {
        super.setUp();
        Session session = this.getSession(this.getRequiredTestModel());
        this.tedHelper = new TransactionalEditingDomainHelper(session.getTransactionalEditingDomain());
    }

    public void test() throws Exception {
        Session session = this.getSession(this.getRequiredTestModel());
        SessionContext context = new SessionContext(session);
        ViewpointManager manager = ViewpointManager.getInstance((ResourceSet)session.getTransactionalEditingDomain().getResourceSet());
        manager.activate("org.polarsys.capella.cybersecurity");
        CyberPABDiagram diagram = CyberPABDiagram.createDiagram(context, "16953dc7-be25-45ef-9da9-32869d0cb53f");
        String c1 = diagram.createBehaviorComponent("comp1", diagram.getDiagramId());
        String c2 = diagram.createBehaviorComponent("comp2", diagram.getDiagramId());
        String f1 = diagram.createFunction("f1", c1);
        String f2 = diagram.createFunction("f2", c2);
        diagram.createFunctionalExchange(f1, f2, "fe");
        CybersecurityServices services = new CybersecurityServices();
        this.executeCommand(() -> {
            this.fpa = services.createFunctionalPrimaryAsset(context.getSemanticElement("16953dc7-be25-45ef-9da9-32869d0cb53f"));
            this.ipa = services.createInformationPrimaryAsset(context.getSemanticElement("16953dc7-be25-45ef-9da9-32869d0cb53f"));
            PrimaryAssetMember m1 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m1.setMember((ModelElement)diagram.getSemanticObjectMap().get(f1));
            PrimaryAssetMember m2 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m2.setMember((ModelElement)diagram.getSemanticObjectMap().get(f2));
            this.fpa.getOwnedMembers().add((Object)m1);
            this.fpa.getOwnedMembers().add((Object)m2);
        });
        diagram.insertPrimaryAsset((PrimaryAsset)this.fpa);
        DNode fpaNode = (DNode)diagram.getView((EObject)this.fpa);
        RGBValues fpaColor = ((Square)fpaNode.getStyle()).getColor();
        DNode f1Node = (DNode)diagram.getViewObjectMap().get(f1);
        DNode f2Node = (DNode)diagram.getViewObjectMap().get(f2);
        CyberPABDiagramTest.assertEquals((Object)fpaColor, (Object)((Square)f1Node.getStyle()).getBorderColor());
        CyberPABDiagramTest.assertEquals((Object)fpaColor, (Object)((Square)f2Node.getStyle()).getBorderColor());
        this.executeCommand(() -> this.fpa.getOwnedMembers().clear());
        this.executeCommand(() -> {
            ExchangeItem ei1 = InformationFactory.eINSTANCE.createExchangeItem();
            ExchangeItem ei2 = InformationFactory.eINSTANCE.createExchangeItem();
            DataPkg p1 = (DataPkg)context.getSemanticElement("dbaec066-1f9c-43e3-9ce1-b295c1e7fc8c");
            p1.getOwnedExchangeItems().add((Object)ei1);
            p1.getOwnedExchangeItems().add((Object)ei2);
            FunctionStorage f1Storage = CybersecurityFactory.eINSTANCE.createFunctionStorage();
            f1Storage.getExchangedItems().add((Object)ei1);
            ((PhysicalFunction)diagram.getSemanticObjectMap().get("f1")).getOwnedExtensions().add((Object)f1Storage);
            FunctionStorage f2Storage = CybersecurityFactory.eINSTANCE.createFunctionStorage();
            f2Storage.getExchangedItems().add((Object)ei1);
            ((PhysicalFunction)diagram.getSemanticObjectMap().get("f2")).getOwnedExtensions().add((Object)f2Storage);
            ((FunctionalExchange)diagram.getSemanticObjectMap().get("fe")).getExchangedItems().add((Object)ei2);
            PrimaryAssetMember m1 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            PrimaryAssetMember m2 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m1.setMember((ModelElement)ei1);
            m2.setMember((ModelElement)ei2);
            this.ipa.getOwnedMembers().add((Object)m1);
            this.ipa.getOwnedMembers().add((Object)m2);
        });
        diagram.insertPrimaryAsset((PrimaryAsset)this.ipa);
        DNode ipaNode = (DNode)diagram.getView((EObject)this.ipa);
        RGBValues ipaColor = ((Square)ipaNode.getStyle()).getColor();
        DEdge feEdge = diagram.getDiagram().getEdges().stream().filter(e -> e.getTarget() == diagram.getSemanticObjectMap().get("fe")).findFirst().get();
        CyberPABDiagramTest.assertEquals((Object)ipaColor, (Object)((Square)f1Node.getStyle()).getBorderColor());
        CyberPABDiagramTest.assertEquals((Object)ipaColor, (Object)((Square)f2Node.getStyle()).getBorderColor());
        CyberPABDiagramTest.assertEquals((Object)ipaColor, (Object)((EdgeStyle)feEdge.getStyle()).getStrokeColor());
        this.executeCommand(() -> {
            String actor1Id = diagram.createActor("actor1", diagram.getDiagramId());
            String actor2Id = diagram.createActor("actor2", diagram.getDiagramId());
            String untrustedActorId = diagram.createActor("untrustedActor", actor1Id);
            String trustedActorId = diagram.createActor("trustedActor", actor2Id);
            AbstractType untrustedActor = ((Part)diagram.getSemanticObjectMap().get("untrustedActor")).getAbstractType();
            TrustBoundaryStorage storage = CybersecurityFactory.eINSTANCE.createTrustBoundaryStorage();
            storage.setTrusted(false);
            untrustedActor.getOwnedExtensions().add((Object)storage);
            String func1 = diagram.createFunction("func1", untrustedActorId);
            String func2 = diagram.createFunction("func2", trustedActorId);
            diagram.createFunctionalExchange(func1, func2, "functional exchange");
            FunctionalExchange functionalExchange = (FunctionalExchange)diagram.getSemanticObjectMap().get("functional exchange");
            diagram.createPhysicalLink(untrustedActorId, trustedActorId, "physical link");
            PhysicalLink physicalLink = (PhysicalLink)diagram.getSemanticObjectMap().get("physical link");
            diagram.createComponentExchange(actor1Id, actor2Id, "component exchange");
            ComponentExchange componentExchange = (ComponentExchange)diagram.getSemanticObjectMap().get("component exchange");
            Allocators.allocate(functionalExchange).on(componentExchange);
            CyberPABDiagramTest.assertTrue((boolean)CybersecurityQueries.isTrustBoundary((FunctionalExchange)functionalExchange));
            CyberPABDiagramTest.assertTrue((boolean)CybersecurityQueries.isTrustBoundary((PhysicalLink)physicalLink));
            CyberPABDiagramTest.assertTrue((boolean)CybersecurityQueries.isTrustBoundary((ComponentExchange)componentExchange));
        });
        this.executeCommand(() -> {
            String actorId = diagram.createActor("actor", diagram.getDiagramId());
            String function1 = diagram.createFunction("function1", actorId);
            String function2 = diagram.createFunction("function2", actorId);
            String function3 = diagram.createFunction("function3", actorId);
            diagram.createFunctionalExchange(function1, function2, "functionalExchange");
            diagram.createFunctionalExchange(function2, function3, "functionalExchange2");
            diagram.createFunctionalChain("path", new String[]{"functionalExchange"});
            FunctionalChain funcChain = (FunctionalChain)diagram.getSemanticObjectMap().get("path");
            diagram.createFunctionalChain("path2", new String[]{"functionalExchange2"});
            FunctionalChain funcChain2 = (FunctionalChain)diagram.getSemanticObjectMap().get("path2");
            this.fpa = services.createFunctionalPrimaryAsset(context.getSemanticElement("16953dc7-be25-45ef-9da9-32869d0cb53f"));
            PrimaryAssetMember m1 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            PrimaryAssetMember m2 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m1.setMember((ModelElement)funcChain2);
            m1.setMember((ModelElement)funcChain);
            this.fpa.getOwnedMembers().add((Object)m1);
            this.fpa.getOwnedMembers().add((Object)m2);
            diagram.insertPrimaryAsset((PrimaryAsset)this.fpa);
            diagram.removeFunctionalChain("path");
            diagram.removeFunctionalChain("path2");
            DDiagramElement functionView = diagram.getView((EObject)diagram.getSemanticObjectMap().get("function1"));
            Style functionStyle = functionView.getStyle();
            DDiagramElement primaryAssetView = diagram.getView((EObject)diagram.getSemanticObjectMap().get(this.fpa.getId()));
            Style primaryAssetStyle = primaryAssetView.getStyle();
            CyberPABDiagramTest.assertEquals((Object)((SquareImpl)functionStyle).getBorderColor(), (Object)((SquareImpl)primaryAssetStyle).getColor());
            DDiagramElement middleFunctionView = diagram.getView((EObject)diagram.getSemanticObjectMap().get("function2"));
            Style middleFunctionStyle = middleFunctionView.getStyle();
            CyberPABDiagramTest.assertEquals((Object)((SquareImpl)middleFunctionStyle).getBorderColor(), (Object)((SquareImpl)primaryAssetStyle).getColor());
        });
        this.executeCommand(() -> {
            String actor3Id = diagram.createActor("actor3", diagram.getDiagramId());
            String function1Id = diagram.createFunction("funct1", actor3Id);
            String function2Id = diagram.createFunction("funct2", actor3Id);
            diagram.createFunctionalExchange(function1Id, function2Id, "exchange");
            ExchangeItem exchangeItem1 = InformationFactory.eINSTANCE.createExchangeItem();
            InterfacePkg pkg = (InterfacePkg)context.getSemanticElement("fe0c0b8b-fb65-49c5-a104-ceb45bc9d285");
            pkg.getOwnedExchangeItems().add((Object)exchangeItem1);
            FunctionalExchange fe = (FunctionalExchange)diagram.getSemanticObjectMap().get("exchange");
            fe.getExchangedItems().add((Object)exchangeItem1);
            PrimaryAssetMember member1 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            member1.setMember((ModelElement)exchangeItem1);
            InformationPrimaryAsset ipa1 = services.createInformationPrimaryAsset(context.getSemanticElement("16953dc7-be25-45ef-9da9-32869d0cb53f"));
            ipa1.getOwnedMembers().add((Object)member1);
            diagram.insertPrimaryAsset((PrimaryAsset)ipa1);
            DDiagramElement exchangeView = diagram.getView((EObject)fe);
            Style exchangeStyle = exchangeView.getStyle();
            DDiagramElement informationAssetView = diagram.getView((EObject)diagram.getSemanticObjectMap().get(ipa1.getId()));
            Style informationAssetStyle = informationAssetView.getStyle();
            CyberPABDiagramTest.assertEquals((Object)((EdgeStyle)exchangeStyle).getStrokeColor(), (Object)((Square)informationAssetStyle).getColor());
            InformationPrimaryAsset ipa2 = services.createInformationPrimaryAsset(context.getSemanticElement("16953dc7-be25-45ef-9da9-32869d0cb53f"));
            PrimaryAssetMember member2 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            member2.setMember((ModelElement)exchangeItem1);
            ipa2.getOwnedMembers().add((Object)member2);
            diagram.insertPrimaryAsset((PrimaryAsset)ipa2);
            diagram.refreshDiagram();
            CyberPABDiagramTest.assertEquals((int)((EdgeStyle)exchangeStyle).getStrokeColor().getBlue(), (int)0);
            CyberPABDiagramTest.assertEquals((int)((EdgeStyle)exchangeStyle).getStrokeColor().getRed(), (int)0);
            CyberPABDiagramTest.assertEquals((int)((EdgeStyle)exchangeStyle).getStrokeColor().getGreen(), (int)0);
        });
        this.executeCommand(() -> this.fpa.getOwnedMembers().clear());
        String compNPC1 = diagram.createNodeComponent("compNPC1", diagram.getDiagramId());
        String compNPC2 = diagram.createNodeComponent("compNPC2", compNPC1);
        String compBPC3 = diagram.createDeployedBehaviorComponent("compBPC3", compNPC2);
        String compBPC4 = diagram.createDeployedBehaviorComponent("compBPC4", compBPC3);
        String physicalFunction1 = diagram.createFunction("physicalFunction1", compBPC4);
        this.executeCommand(() -> {
            this.fpa = services.createFunctionalPrimaryAsset(context.getSemanticElement("16953dc7-be25-45ef-9da9-32869d0cb53f"));
            PrimaryAssetMember m1 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m1.setMember((ModelElement)diagram.getSemanticObjectMap().get("physicalFunction1"));
            this.fpa.getOwnedMembers().add((Object)m1);
            diagram.insertPrimaryAsset((PrimaryAsset)this.fpa);
            CyberDiagramLayers.activateLayer(session, diagram.getDiagram(), "Cybersecurity Supporting Assets");
            diagram.refreshDiagram();
        });
        Integer highlightedBorderSize = new Integer(5);
        Integer borderSize = new Integer(1);
        fpaNode = (DNode)diagram.getView((EObject)this.fpa);
        fpaColor = ((Square)fpaNode.getStyle()).getColor();
        DNode fNode = (DNode)diagram.getViewObjectMap().get("physicalFunction1");
        CyberPABDiagramTest.assertEquals((Object)fpaColor, (Object)((Square)fNode.getStyle()).getBorderColor());
        DNodeContainer fNodeContainer = (DNodeContainer)diagram.getViewObjectMap().get("compNPC2");
        CyberPABDiagramTest.assertEquals((Object)fpaColor, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberPABDiagramTest.assertEquals((Object)highlightedBorderSize, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
        fNodeContainer = (DNodeContainer)diagram.getViewObjectMap().get("compBPC4");
        CyberPABDiagramTest.assertEquals((Object)fpaColor, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberPABDiagramTest.assertEquals((Object)highlightedBorderSize, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
        RGBValues blackColor = RGBValues.create((int)0, (int)0, (int)0);
        fNodeContainer = (DNodeContainer)diagram.getViewObjectMap().get("compNPC1");
        CyberPABDiagramTest.assertEquals((Object)blackColor, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberPABDiagramTest.assertEquals((Object)borderSize, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
        fNodeContainer = (DNodeContainer)diagram.getViewObjectMap().get("compBPC3");
        CyberPABDiagramTest.assertEquals((Object)blackColor, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberPABDiagramTest.assertEquals((Object)borderSize, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
        this.executeCommand(() -> {
            this.threat = services.createThreat((EObject)this.fpa);
            services.createThreatApplication(this.threat, (PrimaryAsset)this.fpa);
            diagram.insertThreat(this.threat);
            diagram.refreshDiagram();
        });
        fNode = (DNode)diagram.getViewObjectMap().get("physicalFunction1");
        CyberPABDiagramTest.assertEquals((Object)blackColor, (Object)((Square)fNode.getStyle()).getBorderColor());
        CyberPABDiagramTest.assertEquals((Object)highlightedBorderSize, (Object)((Square)fNode.getStyle()).getBorderSize());
        fNodeContainer = (DNodeContainer)diagram.getViewObjectMap().get("compNPC2");
        CyberPABDiagramTest.assertEquals((Object)blackColor, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberPABDiagramTest.assertEquals((Object)highlightedBorderSize, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
        fNodeContainer = (DNodeContainer)diagram.getViewObjectMap().get("compBPC4");
        CyberPABDiagramTest.assertEquals((Object)blackColor, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberPABDiagramTest.assertEquals((Object)highlightedBorderSize, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
        diagram.removePrimaryAsset((PrimaryAsset)this.fpa);
        DNode threatNode = (DNode)diagram.getView((EObject)this.threat);
        RGBValues threatColor = ((Square)threatNode.getStyle()).getColor();
        CyberPABDiagramTest.assertEquals((Object)threatColor, (Object)((Square)fNode.getStyle()).getBorderColor());
        CyberPABDiagramTest.assertEquals((Object)highlightedBorderSize, (Object)((Square)fNode.getStyle()).getBorderSize());
        fNodeContainer = (DNodeContainer)diagram.getViewObjectMap().get("compNPC2");
        CyberPABDiagramTest.assertEquals((Object)threatColor, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberPABDiagramTest.assertEquals((Object)highlightedBorderSize, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
        fNodeContainer = (DNodeContainer)diagram.getViewObjectMap().get("compBPC4");
        CyberPABDiagramTest.assertEquals((Object)threatColor, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberPABDiagramTest.assertEquals((Object)highlightedBorderSize, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
        String actorPA1 = diagram.createNodeComponent("actorPA1", compNPC1);
        String actorPA2 = diagram.createNodeComponent("actorPA2", actorPA1);
        String compBPC5 = diagram.createDeployedBehaviorComponent("compBPC5", actorPA2);
        String compBPC6 = diagram.createDeployedBehaviorComponent("compBPC6", compBPC5);
        String physicalFunction3 = diagram.createFunction("physicalFunction3", compBPC6);
        this.executeCommand(() -> {
            PrimaryAssetMember m4 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m4.setMember((ModelElement)diagram.getSemanticObjectMap().get("physicalFunction3"));
            this.fpa.getOwnedMembers().add((Object)m4);
            diagram.refreshDiagram();
        });
        fNode = (DNode)diagram.getViewObjectMap().get("physicalFunction3");
        CyberPABDiagramTest.assertEquals((Object)threatColor, (Object)((Square)fNode.getStyle()).getBorderColor());
        CyberPABDiagramTest.assertEquals((Object)highlightedBorderSize, (Object)((Square)fNode.getStyle()).getBorderSize());
        fNodeContainer = (DNodeContainer)diagram.getViewObjectMap().get("actorPA2");
        CyberPABDiagramTest.assertEquals((Object)threatColor, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberPABDiagramTest.assertEquals((Object)highlightedBorderSize, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
        fNodeContainer = (DNodeContainer)diagram.getViewObjectMap().get("compBPC6");
        CyberPABDiagramTest.assertEquals((Object)threatColor, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberPABDiagramTest.assertEquals((Object)highlightedBorderSize, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
        fNodeContainer = (DNodeContainer)diagram.getViewObjectMap().get("actorPA1");
        CyberPABDiagramTest.assertEquals((Object)blackColor, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberPABDiagramTest.assertEquals((Object)borderSize, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
        fNodeContainer = (DNodeContainer)diagram.getViewObjectMap().get("compBPC5");
        CyberPABDiagramTest.assertEquals((Object)blackColor, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderColor());
        CyberPABDiagramTest.assertEquals((Object)borderSize, (Object)((FlatContainerStyle)fNodeContainer.getStyle()).getBorderSize());
        diagram.createComponentExchange(compBPC3, compBPC5, "CE1");
        ComponentExchange componentExchange = (ComponentExchange)diagram.getSemanticObjectMap().get("CE1");
        ExchangeItem exchangeItem1 = InformationFactory.eINSTANCE.createExchangeItem();
        InterfacePkg pkg = (InterfacePkg)context.getSemanticElement("fe0c0b8b-fb65-49c5-a104-ceb45bc9d285");
        this.executeCommand(() -> {
            pkg.getOwnedExchangeItems().add((Object)exchangeItem1);
            diagram.createFunctionalExchange(physicalFunction1, physicalFunction3, "functionalExchange1");
            FunctionalExchange functionalExchange = (FunctionalExchange)diagram.getSemanticObjectMap().get("functionalExchange1");
            functionalExchange.getExchangedItems().add((Object)exchangeItem1);
            PrimaryAssetMember m1 = CybersecurityFactory.eINSTANCE.createPrimaryAssetMember();
            m1.setMember((ModelElement)exchangeItem1);
            this.ipa = services.createInformationPrimaryAsset(context.getSemanticElement("16953dc7-be25-45ef-9da9-32869d0cb53f"));
            this.ipa.getOwnedMembers().add((Object)m1);
            services.createThreatApplication(this.threat, (PrimaryAsset)this.ipa);
            Allocators.allocate(functionalExchange).on(componentExchange);
            diagram.createPhysicalLink(compNPC2, compNPC1, "PL1");
            PhysicalLink physicalLink = (PhysicalLink)diagram.getSemanticObjectMap().get("PL1");
            ComponentExchangeAllocation a1 = FaFactory.eINSTANCE.createComponentExchangeAllocation();
            a1.setSourceElement((TraceableElement)physicalLink);
            a1.setTargetElement((TraceableElement)componentExchange);
            physicalLink.getOwnedComponentExchangeAllocations().add((Object)a1);
        });
        DEdge componentExchangeEdge = diagram.getDiagram().getEdges().stream().filter(e -> e.getTarget() == diagram.getSemanticObjectMap().get("CE1")).findFirst().get();
        CyberPABDiagramTest.assertEquals((Object)threatColor, (Object)((EdgeStyle)componentExchangeEdge.getStyle()).getStrokeColor());
        CyberPABDiagramTest.assertEquals((Object)highlightedBorderSize, (Object)((EdgeStyle)componentExchangeEdge.getStyle()).getSize());
        DEdge physicalLinkEdge = diagram.getDiagram().getEdges().stream().filter(e -> e.getTarget() == diagram.getSemanticObjectMap().get("PL1")).findFirst().get();
        CyberPABDiagramTest.assertEquals((Object)threatColor, (Object)((EdgeStyle)physicalLinkEdge.getStyle()).getStrokeColor());
        CyberPABDiagramTest.assertEquals((Object)highlightedBorderSize, (Object)((EdgeStyle)physicalLinkEdge.getStyle()).getSize());
    }

    protected final void executeCommand(Runnable r) throws RollbackException, InterruptedException {
        this.tedHelper.executeCommand(r);
    }
}

