/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.sirius.analysis.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.UnexecutableTask;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.tools.internal.command.builders.ContainerCreationCommandBuilder;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.cybersecurity.sirius.analysis.internal.ShowHideNodeContainerTask;

class ShowHideNodeContainerCommandBuilder
extends ContainerCreationCommandBuilder {
    public ShowHideNodeContainerCommandBuilder(ContainerCreationDescription tool, DDiagram diagram) {
        super(tool, diagram);
    }

    public ShowHideNodeContainerCommandBuilder(ContainerCreationDescription tool, DDiagramElementContainer elementContainer) {
        super(tool, elementContainer);
    }

    private boolean canCreateContainerInTarget() {
        boolean containerCanBeCreatedInTarget = false;
        if (this.nodeContainer != null) {
            containerCanBeCreatedInTarget = this.permissionAuthority.canEditInstance((EObject)this.nodeContainer);
            if (containerCanBeCreatedInTarget) {
                EObject target = this.nodeContainer.getTarget();
                containerCanBeCreatedInTarget = target != null && !target.eIsProxy();
            }
        } else if (this.diagram != null && (containerCanBeCreatedInTarget = this.permissionAuthority.canEditInstance((EObject)this.diagram)) && this.diagram instanceof DSemanticDecorator) {
            EObject target = ((DSemanticDecorator)this.diagram).getTarget();
            containerCanBeCreatedInTarget = target != null && !target.eIsProxy();
        }
        return containerCanBeCreatedInTarget;
    }

    protected DCommand buildCreateNodeCommandFromTool(EObject semanticContainer, EObject container) {
        DCommand result = this.createEnclosingCommand();
        if (this.canCreateContainerInTarget()) {
            result.getTasks().add(new ShowHideNodeContainerTask(container, this.tool));
        } else {
            result.getTasks().add(UnexecutableTask.INSTANCE);
        }
        return result;
    }

    protected String getEnclosingCommandLabel() {
        return "show/hide elements";
    }
}

