/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.launch.internal;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.JavaLaunchDelegate;

public enum SupportedLaunchConfigType {
    JDT_JAVA_APPLICATION("org.eclipse.jdt.launching.localJavaApplication"){

        @Override
        protected Set<IPackageFragmentRoot> getSourceFolders(ILaunchConfiguration configuration) throws CoreException {
            JavaLaunchDelegate launchDelegate = new JavaLaunchDelegate();
            IJavaProject javaProject = launchDelegate.getJavaProject(configuration);
            if (javaProject == null) {
                return ImmutableSet.of();
            }
            String mainTypeName = launchDelegate.getMainTypeName(configuration);
            if (mainTypeName == null) {
                return ImmutableSet.of();
            }
            IType mainType = javaProject.findType(mainTypeName);
            if (mainType == null) {
                return ImmutableSet.of();
            }
            IJavaElement pkg = mainType.getPackageFragment().getParent();
            if (!(pkg instanceof IPackageFragmentRoot)) {
                return ImmutableSet.of();
            }
            return ImmutableSet.of((Object)((IPackageFragmentRoot)pkg));
        }
    }
    ,
    JDT_JUNIT("org.eclipse.jdt.junit.launchconfig"){

        @Override
        protected Set<IPackageFragmentRoot> getSourceFolders(ILaunchConfiguration configuration) throws CoreException {
            RelaxedJUnitLaunchConfigurationDelegate launchDelegate = new RelaxedJUnitLaunchConfigurationDelegate();
            IMember[] members = launchDelegate.evaluateTests(configuration);
            ImmutableSet.Builder result = ImmutableSet.builder();
            for (IMember member : members) {
                IJavaElement pkg;
                IType type = member.getDeclaringType();
                if (type == null) {
                    if (!(member instanceof IType)) continue;
                    type = (IType)member;
                }
                if (type == null || !((pkg = type.getPackageFragment().getParent()) instanceof IPackageFragmentRoot)) continue;
                result.add((Object)((IPackageFragmentRoot)pkg));
            }
            return result.build();
        }
    };

    private final String id;

    private SupportedLaunchConfigType(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public static Set<IPackageFragmentRoot> collectSourceFolders(ILaunchConfiguration configuration) throws CoreException {
        SupportedLaunchConfigType type = SupportedLaunchConfigType.launchConfigTypeFor(configuration.getType().getIdentifier());
        if (type == null) {
            return ImmutableSet.of();
        }
        return type.getSourceFolders(configuration);
    }

    public static boolean isSupported(ILaunchConfiguration configuration) {
        try {
            return SupportedLaunchConfigType.launchConfigTypeFor(configuration.getType().getIdentifier()) != null;
        }
        catch (CoreException e) {
            return false;
        }
    }

    private static SupportedLaunchConfigType launchConfigTypeFor(String typeId) {
        for (SupportedLaunchConfigType type : SupportedLaunchConfigType.values()) {
            if (!type.getId().equals(typeId)) continue;
            return type;
        }
        return null;
    }

    protected abstract Set<IPackageFragmentRoot> getSourceFolders(ILaunchConfiguration var1) throws CoreException;

    private static class RelaxedJUnitLaunchConfigurationDelegate
    extends JUnitLaunchConfigurationDelegate {
        private RelaxedJUnitLaunchConfigurationDelegate() {
        }

        public IMember[] evaluateTests(ILaunchConfiguration configuration) throws CoreException {
            return this.evaluateTests(configuration, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

