/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.emf.visualizations;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.app4mc.visualization.ui.VisualizationParameters;

public class EObjectRefsConfig {
    private static final String HORIZONTAL_LAYOUT_KEY = "HorizontalLayout";
    private static final String HORIZONTAL_LAYOUT_DEFAULT = "false";
    private static final String SHOW_REFERENCE_LABELS_KEY = "ShowReferenceLabels";
    private static final String SHOW_REFERENCE_LABELS_DEFAULT = "false";
    private static final String SHOW_DERIVED_REFERENCES_KEY = "ShowDerivedReferences";
    private static final String SHOW_DERIVED_REFERENCES_DEFAULT = "false";
    private static final String SCALE_KEY = "Scale";
    private static final String SCALE_DEFAULT = "100";
    private final VisualizationParameters parameters;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public EObjectRefsConfig(VisualizationParameters viewParameters) {
        this.parameters = viewParameters;
    }

    public boolean isHorizontalLayout() {
        return Boolean.parseBoolean(this.parameters.getOrDefault((Object)HORIZONTAL_LAYOUT_KEY, "false"));
    }

    public void setHorizontalLayout(boolean horizontal) {
        this.parameters.put(HORIZONTAL_LAYOUT_KEY, Boolean.toString(horizontal));
        this.firePropertyChange("parameter1", null, horizontal);
    }

    public boolean isShowReferenceLabels() {
        return Boolean.parseBoolean(this.parameters.getOrDefault((Object)SHOW_REFERENCE_LABELS_KEY, "false"));
    }

    public void setShowReferenceLabels(boolean showLabels) {
        this.parameters.put(SHOW_REFERENCE_LABELS_KEY, Boolean.toString(showLabels));
        this.firePropertyChange("parameter2", null, showLabels);
    }

    public boolean isShowDerivedReferences() {
        return Boolean.parseBoolean(this.parameters.getOrDefault((Object)SHOW_DERIVED_REFERENCES_KEY, "false"));
    }

    public void setShowDerivedReferences(boolean showDerived) {
        this.parameters.put(SHOW_DERIVED_REFERENCES_KEY, Boolean.toString(showDerived));
        this.firePropertyChange("parameter3", null, showDerived);
    }

    public int getScale() {
        return Integer.parseInt(this.parameters.getOrDefault((Object)SCALE_KEY, SCALE_DEFAULT));
    }

    public boolean setScale(int newScale) {
        int oldScale = this.getScale();
        if (oldScale == newScale || newScale < 10 || newScale > 200) {
            return false;
        }
        this.parameters.put(SCALE_KEY, Integer.toString(newScale));
        this.firePropertyChange("scale", oldScale, newScale);
        return true;
    }

    public boolean decrementScale() {
        return this.setScale(Math.max(10, this.getScale() - 10));
    }

    public boolean incrementScale() {
        return this.setScale(Math.min(200, this.getScale() + 10));
    }

    public void addChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removeChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

