/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.workflow.component;

import java.util.List;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.IActivityGraphItemContainer;
import org.eclipse.app4mc.amalthea.model.Preemption;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.util.SoftwareUtil;
import org.eclipse.app4mc.amalthea.workflow.core.Context;
import org.eclipse.app4mc.amalthea.workflow.core.WorkflowComponent;
import org.eclipse.app4mc.amalthea.workflow.core.exception.WorkflowException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class AddSchedulePoints
extends WorkflowComponent {
    @Override
    protected void runInternal(Context ctx) {
        if (this.getAmaltheaModel(ctx).getSwModel() == null) {
            throw new WorkflowException("No proper SWModel available in slot " + this.getModelSlot());
        }
        if (this.getAmaltheaModel(ctx).getSwModel().getTasks().isEmpty()) {
            throw new WorkflowException("No Tasks available to check in slot " + this.getModelSlot());
        }
        this.addSchedulePointsToTasks((List<Task>)this.getAmaltheaModel(ctx).getSwModel().getTasks());
    }

    public void addSchedulePointsToTasks(List<Task> tasks) {
        for (Task task : tasks) {
            if (task.getActivityGraph() == null || !task.getPreemption().equals((Object)Preemption.COOPERATIVE)) continue;
            this.log.info((Object)("Adding schedule points to cooperative Task [" + task.getName() + "]"));
            EList calls = SoftwareUtil.collectActivityGraphItems((IActivityGraphItemContainer)task.getActivityGraph(), null, RunnableCall.class);
            for (RunnableCall rc : calls) {
                EObject container = rc.eContainer();
                EStructuralFeature feature = rc.eContainingFeature();
                if (container == null || feature == null || !feature.isMany()) continue;
                EList list = (EList)container.eGet(feature);
                int index = list.indexOf((Object)rc);
                list.add(index + 1, (Object)AmaltheaFactory.eINSTANCE.createSchedulePoint());
            }
        }
    }
}

