/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.editor.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Named;
import org.eclipse.app4mc.amalthea.model.editor.container.AmaltheaModelContainer;
import org.eclipse.app4mc.amalthea.model.editor.util.AmaltheaEditorUtil;
import org.eclipse.app4mc.amalthea.model.emf.AmaltheaResource;
import org.eclipse.app4mc.amalthea.model.io.AmaltheaFileHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;

public class CompressHandler {
    private static final int BUFFER_SIZE = 2048;
    private static final String COMPRESS_ERROR = "Compress error";

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") IStructuredSelection selection, Shell shell, IDecoratorManager decoratorManager) {
        IFile iFile;
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof IFile && AmaltheaFileHelper.isModelFileExtension((String)(iFile = (IFile)firstElement).getFileExtension())) {
            AmaltheaModelContainer modelContainer = AmaltheaEditorUtil.getModelContainer(iFile);
            if (modelContainer != null && modelContainer.getInitialModelFiles().contains(iFile)) {
                this.markResourceZipped(iFile, modelContainer);
                this.showInfoDialog();
            } else {
                this.zipModelFile(iFile, shell, decoratorManager);
            }
        }
    }

    private void showInfoDialog() {
        Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Compress", (String)"Resource successfully marked as \"zipped\".\n\nSave the model to persist changes."));
    }

    private void markResourceZipped(IFile iFile, AmaltheaModelContainer modelContainer) {
        ResourceSet resourceSet = modelContainer.getResourceSet();
        if (resourceSet != null) {
            for (Resource resource : resourceSet.getResources()) {
                if (!(resource instanceof AmaltheaResource) || !resource.getURI().lastSegment().equals(iFile.getName())) continue;
                ((AmaltheaResource)resource).setUseZip(true);
                resource.setModified(true);
                modelContainer.updateDirtyStateOfEditors();
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void zipModelFile(IFile iFile, Shell shell, IDecoratorManager decoratorManager) {
        File modelFileTmp;
        File modelFile;
        block21: {
            if (!AmaltheaEditorUtil.isRegularFile(iFile)) {
                MessageDialog.openError((Shell)shell, (String)COMPRESS_ERROR, (String)"Invalid file!");
                return;
            }
            modelFile = AmaltheaEditorUtil.getLocalFile((IResource)iFile);
            modelFileTmp = new File(modelFile.getParentFile(), String.valueOf(modelFile.getName()) + ".tmp");
            try {
                Throwable throwable = null;
                Object var7_11 = null;
                try {
                    FileInputStream inputStream = new FileInputStream(modelFile);
                    try {
                        try (ZipOutputStream outputStream = new ZipOutputStream(new FileOutputStream(modelFileTmp));){
                            int length;
                            ZipEntry zipEntry = new ZipEntry("ResourceContents");
                            outputStream.putNextEntry(zipEntry);
                            byte[] bytes = new byte[2048];
                            while ((length = inputStream.read(bytes)) >= 0) {
                                outputStream.write(bytes, 0, length);
                            }
                        }
                        if (inputStream == null) break block21;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)shell, (String)COMPRESS_ERROR, (String)("Failed to compress model file! " + e.getMessage()));
                return;
            }
        }
        try {
            Files.delete(modelFile.toPath());
            Files.move(modelFileTmp.toPath(), modelFile.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)shell, (String)COMPRESS_ERROR, (String)("Failed to replace model file! " + e.getMessage()));
        }
        try {
            iFile.refreshLocal(2, null);
            decoratorManager.update("org.eclipse.app4mc.amalthea.file.compressed.decorator");
            return;
        }
        catch (CoreException e) {
            Platform.getLog(this.getClass()).error(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

