/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.standard;

import javafx.embed.swt.FXCanvas;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javax.annotation.PostConstruct;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.visualizations.standard.util.RunnableHelper;
import org.eclipse.app4mc.amalthea.visualizations.standard.util.RunnablePainter;
import org.eclipse.app4mc.visualization.ui.VisualizationParameters;
import org.eclipse.app4mc.visualization.ui.registry.Visualization;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.component.annotations.Component;

@Component(property={"name=LabelAccess View", "description=Graphical representation of Runnable LabelAccess definition"})
public class RunnableVisualization
implements Visualization {
    @PostConstruct
    public void createVisualization(Runnable runnable, VisualizationParameters parameters, Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        FXCanvas fxCanvas = new FXCanvas(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)fxCanvas);
        BorderPane layout = new BorderPane();
        layout.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)}));
        Scene scene = new Scene((Parent)layout);
        fxCanvas.setScene(scene);
        RunnablePainter painter = new RunnablePainter(runnable);
        double minWidth = painter.getPreferredMinimumWidth();
        double minHeight = painter.getPreferredMinimumHeight();
        double max = Math.max(minWidth, minHeight);
        double maxFactor = 6000.0 / max;
        painter.setMaxScaleFactor(maxFactor);
        painter.setScaleFactor(RunnableHelper.getScaleFactor(parameters));
        Button zoomIn = new Button("+");
        zoomIn.setPrefSize(40.0, 40.0);
        Button zoomOut = new Button("-");
        zoomOut.setPrefSize(40.0, 40.0);
        zoomIn.setOnAction(event -> {
            if (!zoomIn.isDisabled()) {
                painter.zoomIn();
                double scaleFactor = painter.getScaleFactor();
                RunnableHelper.persistScaleFactor(scaleFactor, parameters);
                if (scaleFactor >= painter.getMaxScaleFactor()) {
                    zoomIn.setDisable(true);
                }
                if (zoomOut.isDisabled()) {
                    zoomOut.setDisable(false);
                }
            }
            parent.redraw();
        });
        zoomOut.setOnAction(event -> {
            if (!zoomOut.isDisabled()) {
                painter.zoomOut();
                double scaleFactor = painter.getScaleFactor();
                RunnableHelper.persistScaleFactor(scaleFactor, parameters);
                if (scaleFactor <= 0.1) {
                    zoomOut.setDisable(true);
                }
                if (zoomIn.isDisabled()) {
                    zoomIn.setDisable(false);
                }
            }
            parent.redraw();
        });
        VBox vBox = new VBox(5.0);
        vBox.setPadding(new Insets(5.0));
        vBox.getChildren().addAll((Object[])new Node[]{zoomIn, zoomOut});
        layout.setLeft((Node)vBox);
        if (painter.getScaleFactor() >= painter.getMaxScaleFactor()) {
            zoomIn.setDisable(true);
        }
        if (painter.getScaleFactor() <= 0.1) {
            zoomOut.setDisable(true);
        }
        Canvas canvas = new Canvas();
        ScrollPane scrollable = new ScrollPane();
        scrollable.setPadding(new Insets(0.0));
        scrollable.setStyle("-fx-background: rgb(255,255,255);\n -fx-background-color: rgb(255,255,255)");
        scrollable.setContent((Node)canvas);
        layout.setCenter((Node)scrollable);
        canvas.setOnScroll(event -> {
            if (event.isControlDown()) {
                double deltaY = event.getDeltaY();
                if (deltaY < 0.0) {
                    zoomOut.fire();
                } else {
                    zoomIn.fire();
                }
                event.consume();
            }
        });
        GraphicsContext gc = canvas.getGraphicsContext2D();
        parent.addPaintListener(e -> {
            double parentBoundsHeight;
            org.eclipse.swt.graphics.Rectangle parentBounds = parent.getBounds();
            double scaledColumnWidth = painter.getPreferredMinimumWidth() * painter.getScaleFactor();
            double scaledRowHeight = painter.getPreferredMinimumHeight() * painter.getScaleFactor();
            double canvasWidth = scaledColumnWidth;
            double canvasHeight = scaledRowHeight;
            double parentBoundsWidth = (double)parentBounds.width - 30.0 - vBox.getWidth();
            if (parentBoundsWidth > scaledColumnWidth) {
                canvasWidth = parentBoundsWidth;
            }
            if ((parentBoundsHeight = (double)parentBounds.height - 30.0) > scaledRowHeight) {
                canvasHeight = parentBoundsHeight;
            }
            canvasWidth = Math.min(6000.0, canvasWidth);
            canvasHeight = Math.min(6000.0, canvasHeight);
            canvas.setWidth(canvasWidth);
            canvas.setHeight(canvasHeight);
            gc.clearRect(0.0, 0.0, canvasWidth, canvasHeight);
            Rectangle bounds = new Rectangle(Double.valueOf(parentBounds.x).doubleValue(), Double.valueOf(parentBounds.y).doubleValue(), Double.valueOf(scaledColumnWidth).doubleValue(), Double.valueOf(scaledRowHeight).doubleValue());
            painter.paint(gc, bounds);
        });
    }
}

